package com.huigou.topsun.sap.nonOrderStorage.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/13:55
 * @Description: 无订单库存入库流程
 */
@Data
@Entity
@Table(name = "sap_non_order_storage")
public class NonOrderStorage extends FlowBillAbstractEntity {

    /**
     * 品名
     */
    @Column(name = "product_code")
    private String productCode;

    @Column(name = "product_name")
    private String productName;
    /**
     * 数量
     */
    @Column(name = "number")
    private BigDecimal number;
    /**
     * 单位
     */
    @Column(name = "unit")
    private String unit;

    /**
     * 单位
     */
    @Column(name = "unit_name")
    private String unitName;

    /**
     * 是否收费
     */
    @Column(name = "is_charge")
    private String isCharge;

    /**
     * 事由
     */
    @Column(name = "reason")
    private String reason;

    /**
     * 工厂
     */
    @Column(name = "werks")
    private String werks;

    /**
     * 工厂名称
     */
    @Column(name = "werks_name")
    private String werksName;

    /**
     * 库存地点
     */
    @Column(name = "store")
    private String store;

    /**
     * 库存地点名称
     */
    @Column(name = "store_name")
    private String storeName;

    /**
     * 供应商
     */
    @Column(name = "supplier")
    private String supplier;

    /**
     * 供应商
     */
    @Column(name = "supplier_name")
    private String supplierName;
    /**
     * 消息类型
     */
    @Column(name = "type")
    private String type;

    /**
     * 消息文本
     */
    @Column(name = "message")
    private String message;

    /**
     * 总价值
     */
    @Column(name = "amount")
    private BigDecimal amount;

    @Override
    protected String getCodeRuleId() {
        return "nonOrderStorage";
    }
}
