package com.huigou.topsun.sap.nonOrderStorage.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.context.Operator;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.costReimbursement.domain.SapCostReimbursement;
import com.huigou.topsun.sap.nonOrderStorage.domain.NonOrderStorage;
import com.huigou.topsun.sap.nonOrderStorage.application.NonOrderStorageApplication;
import com.huigou.topsun.sap.nonOrderStorage.domain.query.NonOrderStorageQueryRequest;
import com.huigou.topsun.sap.nonOrderStorage.repository.NonOrderStorageRepository;
import com.huigou.topsun.sap.suppliers.domain.SuppliersInfo;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import com.huigou.util.StringUtil;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/14:09
 * @Description:
 */
@Service("nonOrderStorageApplication")
public class NonOrderStorageApplicationImpl extends FlowBroker implements NonOrderStorageApplication {
    @Autowired
    private NonOrderStorageRepository nonOrderStorageRepository;

    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        NonOrderStorage nonOrderStorage = getBizEntity(NonOrderStorage.class);
        if (nonOrderStorage.isNew()) {
            Operator operator = this.getOperator();
            BeanUtils.copyProperties(operator, nonOrderStorage);
            nonOrderStorage.setStatusId(BizBillStatus.APPLYING.getId());

        } else {
            nonOrderStorage = (NonOrderStorage) commonDomainService.loadAndFillinProperties(nonOrderStorage);
        }
        nonOrderStorage = nonOrderStorageRepository.save(nonOrderStorage);
        return nonOrderStorage.getId();
    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        NonOrderStorage nonOrderStorage = nonOrderStorageRepository.findOne(bizId);
        nonOrderStorage.setStatusId(BizBillStatus.ABORTED.getId());
        nonOrderStorageRepository.save(nonOrderStorage);
    }

    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            NonOrderStorage nonOrderStorage = nonOrderStorageRepository.findOne(bizId);
            nonOrderStorage.setStatusId(BizBillStatus.APPLYING.getId());
            nonOrderStorageRepository.save(nonOrderStorage);
        }
    }

    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        return ClassHelper.toMap(nonOrderStorageRepository.getOne(bizId));
    }

    @Override
    protected void onBeforeComplete(DelegateTask delegateTask) {
        super.onBeforeComplete(delegateTask);
        String bizId = delegateTask.getExecution().getProcessBusinessKey();
        NonOrderStorage nonOrderStorage = nonOrderStorageRepository.findOne(bizId);
        nonOrderStorage.setStatusId(BizBillStatus.APPROVING.getId());
        nonOrderStorageRepository.save(nonOrderStorage);
    }

    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        //super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        NonOrderStorage nonOrderStorage = nonOrderStorageRepository.findOne(bizId);
        nonOrderStorage.setStatusId(status.getId());
        //this.sendSapCenterData(nonOrderStorage);
        nonOrderStorageRepository.save(nonOrderStorage);
    }

    /**
     * 流程撤销事件
     **/
    @Override
    protected void onRecallProcessInstance(DelegateExecution delegateExecution) {
        String bizId = delegateExecution.getProcessBusinessKey();
        // 修改单据状态为申请
        updateStatus(bizId, BizBillStatus.APPLYING);
    }

    /**
     * 回收事件
     **/
    @Override
    protected void onWithdraw(DelegateTask delegateTask, String destActivityId) {
        super.onWithdraw(delegateTask, destActivityId);
        String bizId = delegateTask.getExecution().getProcessBusinessKey();
        if (destActivityId.equalsIgnoreCase("apply")) {
            updateStatus(bizId, BizBillStatus.APPLYING);
        }
    }

    @Transactional
    protected void updateStatus(String bizId, BizBillStatus status) {
        Assert.hasText(bizId, CommonDomainConstants.ID_NOT_BLANK);
        this.commonDomainService.updateStatus(NonOrderStorage.class, bizId, status.getId());
    }

    @Override
    public Map<String, Object> slicedNonOrderStorageList(NonOrderStorageQueryRequest nonOrderStorageQueryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "nonOrderStorage");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, nonOrderStorageQueryRequest);

        if (StringUtil.isNotBlank(nonOrderStorageQueryRequest.getBillCode())) {
            queryModel.addCriteria(" and t.bill_code like:billCode");
            queryModel.putLikeParam("billCode", nonOrderStorageQueryRequest.getBillCode());
        }
        if (StringUtil.isNotBlank(nonOrderStorageQueryRequest.getProductName())) {
            queryModel.addCriteria(" and t.product_name like:productName");
            queryModel.putLikeParam("productName", nonOrderStorageQueryRequest.getProductName());
        }
        if (StringUtil.isNotBlank(nonOrderStorageQueryRequest.getSupplier())) {
            queryModel.addCriteria(" and t.supplier =:supplier");
            queryModel.putParam("supplier", nonOrderStorageQueryRequest.getSupplier());
        }
        if (nonOrderStorageQueryRequest.getStatus() != null) {
            queryModel.addCriteria(" and t.status =:status");
            queryModel.putParam("status", nonOrderStorageQueryRequest.getStatus());
        }
        queryModel.putDictionary("status", DictUtil.getDictionary("bizBillStatus"));
        queryModel.putDictionary("isCharge", DictUtil.getDictionary("yesorno"));
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public void deleteNonOrderStorageById(List<String> ids) {
        for (String id : ids) {
            nonOrderStorageRepository.delete(id);
        }
    }

    @Override
    public void saveNonOrderStorage(NonOrderStorage nonOrderStorage) {
        nonOrderStorageRepository.save(nonOrderStorage);
    }
    
    @Override
    public NonOrderStorage sendSapCenterData(NonOrderStorage nonOrderStorage) {
        return null;
    }

    @Override
    public NonOrderStorage findNonOrderStorageById(String id) {
        return nonOrderStorageRepository.findOne(id);
    }
}
