package com.huigou.topsun.sap.inventoryRecord.application.impl;

import cn.hutool.core.bean.BeanUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.inventoryRecord.application.InventoryRecordItemWmApplication;
import com.huigou.topsun.sap.inventoryRecord.domain.InventoryRecordItemWm;
import com.huigou.topsun.sap.inventoryRecord.domain.query.InventoryRecordQueryRequest;
import com.huigou.topsun.sap.inventoryRecord.domain.vo.InventoryRecordVo;
import com.huigou.topsun.sap.inventoryRecord.repository.InventoryRecordItemWmRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/7/1710:38
 */
@Service("inventoryRecordItemWmApplication")
public class InventoryRecordItemWmApplicationImpl extends BaseApplication implements InventoryRecordItemWmApplication {
    @Autowired
    private InventoryRecordItemWmRepository inventoryRecordItemWmRepository;

    @Override
    public void saveInventoryRecordItemWms(String inventoryRecordId, List<InventoryRecordItemWm> inventoryRecordItemWms) {
        inventoryRecordItemWms.forEach(inventoryRecordItemWm -> {
            inventoryRecordItemWm.setInventoryRecordId(inventoryRecordId);
            inventoryRecordItemWmRepository.save(inventoryRecordItemWm);
        });
    }

    @Override
    public Map<String, Object> queryInventoryRecordItemWms(InventoryRecordQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getInventoryRecordId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "inventoryRecordItemWms");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public List<InventoryRecordItemWm> queryInventoryRecordItemWms(String inventoryRecordId) {
        return inventoryRecordItemWmRepository.findByInventoryRecordId(inventoryRecordId);
    }

    @Override
    public void saveInventoryRecordWmVo(List<InventoryRecordVo> inventoryRecordVos, String inventoryRecordId) {
        List<InventoryRecordItemWm> inventoryRecordItemWms = new ArrayList<>();
        for (InventoryRecordVo inventoryRecordVo : inventoryRecordVos) {
            InventoryRecordItemWm inventoryRecordItemWm = new InventoryRecordItemWm();
            BeanUtil.copyProperties(inventoryRecordVo,inventoryRecordItemWm);
            inventoryRecordItemWm.setInventoryRecordId(inventoryRecordId);
            inventoryRecordItemWms.add(inventoryRecordItemWm);
        }
        inventoryRecordItemWmRepository.save(inventoryRecordItemWms);
    }
}
