package com.huigou.topsun.sap.fixedAssets.domain.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * title:
 * author:ZHT
 * date:2023/12/29
 * description:
 */
@JsonIgnoreProperties
public class SapFixedAssetsReturnVo implements Serializable {

    /**
     * BPM单号
     */
    @JsonProperty("ZFIBPMNR")
    private String zfibpmnr;

    /**
     * 创建标识
     * 用于标识数据是新增或修改，1为新增，2为修改。（必填）
     */
    @JsonProperty("ZFIFLG")
    private Integer zfiflg;

    /**
     * 主资产号
     * ;资产编号内部生成，当创建标识为2，即修改时，主资产号为必输。
     */
    @JsonProperty(value = "ANLN1",required = true)
    private String anln1;

    /**
     * 资产分类
     * 当创建标识为1，即创建时，资产分类必输。
     */
    @JsonProperty(value = "ANLKL",required = true)
    private String anlkl;

    /**
     * 公司代码（必填）
     */
    @JsonProperty("BUKRS")
    private String bukrs;

    /**
     * 文本（必填）
     */
    @JsonProperty("TXT50")
    private String txt50;

    /**
     * 规格型号
     */
    @JsonProperty("TXA50")
    private String txa50;

    /**
     * 存货号；存放地点
     */
    @JsonProperty(value = "INVNR",required = true)
    private String invnr;

    /**
     * 数量
     */
    @JsonProperty(value = "MENGE",required = true)
    private BigDecimal menge;

    /**
     * 基本计量单位
     */
    @JsonProperty(value = "MEINS",required = true)
    private String meins;

    /**
     * 成本中心（必填）
     */
    @JsonProperty("KOSTL")
    private String kostl;

    /**
     * 责任成本中心
     */
    @JsonProperty(value = "KOSTLV",required = true)
    private String kostlv;

    /**
     * 使用情况
     * 1-外购、2-自制、3-合并新增
     */
    @JsonProperty("ORD41")
    private String ord41;

    /**
     * 取得方式
     * 1-在用、2-闲置、3-在建 、4-停建
     */
    @JsonProperty("ORD42")
    private String ord42;

    public String getOrd41() {
        return ord41;
    }

    public void setOrd41(String ord41) {
        this.ord41 = ord41;
    }

    public String getOrd42() {
        return ord42;
    }

    public void setOrd42(String ord42) {
        this.ord42 = ord42;
    }

    public String getZfibpmnr() {
        return zfibpmnr;
    }

    public void setZfibpmnr(String zfibpmnr) {
        this.zfibpmnr = zfibpmnr;
    }

    public Integer getZfiflg() {
        return zfiflg;
    }

    public void setZfiflg(Integer zfiflg) {
        this.zfiflg = zfiflg;
    }

    public String getAnln1() {
        return anln1;
    }

    public void setAnln1(String anln1) {
        this.anln1 = anln1;
    }

    public String getAnlkl() {
        return anlkl;
    }

    public void setAnlkl(String anlkl) {
        this.anlkl = anlkl;
    }

    public String getBukrs() {
        return bukrs;
    }

    public void setBukrs(String bukrs) {
        this.bukrs = bukrs;
    }

    public String getTxt50() {
        return txt50;
    }

    public void setTxt50(String txt50) {
        this.txt50 = txt50;
    }

    public String getTxa50() {
        return txa50;
    }

    public void setTxa50(String txa50) {
        this.txa50 = txa50;
    }

    public String getInvnr() {
        return invnr;
    }

    public void setInvnr(String invnr) {
        this.invnr = invnr;
    }

    public BigDecimal getMenge() {
        return menge;
    }

    public void setMenge(BigDecimal menge) {
        this.menge = menge;
    }

    public String getMeins() {
        return meins;
    }

    public void setMeins(String meins) {
        this.meins = meins;
    }

    public String getKostl() {
        return kostl;
    }

    public void setKostl(String kostl) {
        this.kostl = kostl;
    }

    public String getKostlv() {
        return kostlv;
    }

    public void setKostlv(String kostlv) {
        this.kostlv = kostlv;
    }
}
