package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.topsun.common.AbstractPortalOrg;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author xin.lu
 * @Description: 固定资产导入临时表。
 * @date 2025/8/514:08
 */
@Table(name = "tmp_fixed_assets_data")
@Entity
@Getter
@Setter
public class TmpFixedAssetsData extends AbstractPortalOrg {

    /**
     * 主资产号
     * ;资产编号内部生成，当创建标识为2，即修改时，主资产号为必输。
     */
    @Column(name = "anln1")
    private String anln1;

    /**
     * 资产分类
     * 当创建标识为1，即创建时，资产分类必输。
     */
    @Column(name = "anlkl")
    private String anlkl;

    @Column(name = "anlkl_name")
    private String anlklName;

    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;

    @Column(name = "bukrs_name")
    private String bukrsName;

    /**
     * 文本（必填）
     */
    @Column(name = "txt50")
    private String txt50;

    /**
     * 规格型号
     */
    @Column(name = "txa50")
    private String txa50;

    /**
     * 存货号；存放地点
     */
    @Column(name = "invnr")
    private String invnr;

    /**
     * 数量
     */
    @Column(name = "menge")
    private BigDecimal menge;

    /**
     * 基本计量单位
     */
    @Column(name = "meins")
    private String meins;

    @Column(name = "meins_name")
    private String meinsName;

    /**
     * 成本中心（必填）
     */
    @Column(name = "kostl")
    private String kostl;

    /**
     * 成本中心（必填）
     */
    @Column(name = "kostl_name")
    private String kostlName;

    /**
     * 责任成本中心
     */
    @Column(name = "kostlv")
    private String kostlv;

    /**
     * 责任成本中心
     */
    @Column(name = "kostlv_name")
    private String kostlvName;

    /**
     * 使用情况
     * 1-外购、2-自制、3-合并新增
     */
    @Column(name = "ORD41")
    private String ord41;

    /**
     * 取得方式
     * 1-在用、2-闲置、3-在建 、4-停建
     */
    @Column(name = "ORD42")
    private String ord42;
}
