package com.huigou.topsun.sap.fixedAssets.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssessApplication;

import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssess;
import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedAssessData;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssessQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.dataimport.application.ExcelImportApplication;
import com.huigou.util.CommonUtil;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/13/10:34
 * @Description:
 */
@Controller
@ControllerMapping("/sapFixedAssess")
public class SapFixedAssessController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/fixedAssets/sapFixedAssess/";
    }

    @Resource
    private SapFixedAssessApplication sapFixedAssessApplication;


    private ExcelImportApplication excelImportApplication;

    public String forwardSapFixedAssessList(){
        return forward("sapFixedAssessList");
    }

    public String slicedSapFixedAssessList(){
        SDO sdo = this.getSDO();
        SapFixedAssessQueryRequest queryRequest = sdo.toQueryRequest(SapFixedAssessQueryRequest.class);
        Map<String, Object> map = sapFixedAssessApplication.getFixedAssessList(queryRequest);
        return toResult(map);
    }

    public String forwardSapFixedAssessDetail(){
        this.putAttribute("processDefinitionKey", SapFixedAssessApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapFixedAssess sapAssess = new SapFixedAssess();
        sapAssess.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        sapAssess.setAttbizId(CommonUtil.createGUID()); // 自动生成附件id
        Operator operator = getOperator();
        sapAssess.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
       // ExcelImportTemplate excelImportTemplate=excelImportApplication.loadExcelImportTemplateByCode("sapFixedAssessData");
        return forward("sapFixedAssessDetail",sapAssess);
    }

    public String showFixedAssess(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
       // this.putAttribute("attbizId", id); // 设置附件id
        SapFixedAssess sapAssess = sapFixedAssessApplication.getFixedAssessById(id);
       // sapAssess.setAttbizId(id);
        return forward("sapFixedAssessDetail",sapAssess);
    }

    /**
     * 删除在建工程转固
     */
    public String deleteSapFixedAssess() {
        List<String> ids = this.getSDO().getIds();
        sapFixedAssessApplication.deleteByIds(ids);
        return success();
    }
    /*
     *返回导入数据
    */
    public String importExcelData() {
        SDO sdo = this.getSDO();
        String batchNumber = sdo.getString("batchNumber");
        List<TmpFixedAssessData> dataList=sapFixedAssessApplication.importExcelData(batchNumber);
     //   return dataList;
        return toResult(dataList);
    }
}
