package com.huigou.topsun.sap.fixedAssets.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsMoveItemApplication;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedRetirementItemApplication;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssetsMoveItem;
import com.huigou.topsun.sap.fixedAssets.domain.SapRetirementItem;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsMoveQueryRequest;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedRetirementQueryRequest;
import com.huigou.topsun.sap.fixedAssets.repository.SapFixedAssetsMoveItemRepository;
import com.huigou.topsun.sap.fixedAssets.repository.SapFixedRetirementItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/09/10:16
 * @Description:
 */
@Service("sapFixedRetirementItemApplication")
public class SapFixedRetirementItemApplicationImpl extends BaseApplication implements SapFixedRetirementItemApplication {
    @Autowired
    private SapFixedRetirementItemRepository sapFixedRetirementItemRepository;
    @Override
    public void saveSapFixedRetirementItems(String sapFixedRetirementId, List<SapRetirementItem> items) {
        for (SapRetirementItem item : items) {
            item.setSapRetirementId(sapFixedRetirementId);
            sapFixedRetirementItemRepository.save(item);
        }
    }

    @Override
    public Map<String, Object> querySapFixedRetirementItems(SapFixedRetirementQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapRetirementId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapFixedRetirementItems");

            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            if (queryRequest.getSapRetirementId() != null) {
                queryModel.addCriteria(" and t.sap_retirement_id =:sapRetirementId");
                queryModel.putParam("sapRetirementId", queryRequest.getSapRetirementId());
            }
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapFixedRetirementItemRepository.delete(id);
        });
    }

    @Override
    public List<SapRetirementItem> findBySapFixedRetirementId(String sapRetirementId) {
        return sapFixedRetirementItemRepository.findBySapRetirementId(sapRetirementId);
    }
}
