package com.huigou.topsun.sap.exceptionReport.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
@Data
public class PurchaseOrderItemVo implements Serializable {

    /**
     * SAP采购订单
     */
    @JsonProperty("EBELN")
    private String ebeln;

    /**
     * 订单行项目号
     */
    @JsonProperty("EBELP")
    private String ebelp;

    /**
     * 物料编码
     */
    @JsonProperty("MATNR")
    private String matnr;

    /**
     * 物料描述
     */
    @JsonProperty("MAKTX")
    private String txz01;

    /**
     * 数量
     */
    @JsonProperty("MENGE")
    private BigDecimal menge;

    /**
     * 单位
     */
    @JsonProperty("MEINS")
    private String meins;

    /**
     * 需求到货日期
     */
    @JsonProperty("EEIND")
    private String eeind;
    /**
     * 工厂
     */
    @JsonProperty("WERKS")
    private String werks;

    /**
     * 存储地点
     */
    @JsonProperty("LGORT")
    private String lgort;

    /**
     * 免费项目
     */
    @JsonProperty("UMSON")
    private String umson;

    /**
     * 操作/活动编号
     */
    @JsonProperty("VORNR")
    private String vornr;

    /**
     * 收货方
     */
    @JsonProperty("WEMPF")
    private String wempf;

    /**
     * 同一工序外发次数
     * 自动计数器，匹配条件为“如果之前状态为通过的申请中有相同工单+工序，则计数器+1，起始为1”
     */
    @JsonProperty("ABLAD")
    private String ablad;

    /**
     * 单价
     */
    @JsonProperty("KBETR")
    private BigDecimal kbetr;

    /**
     * 税码
     */
    @JsonProperty("MWSKZ")
    private String purchaseMwskz;

    /**
     * 物料组
     */
    @JsonProperty("MATKL")
    private String matkl;


    /**
     * 科目分配类别
     */
    @JsonProperty("KNTTP")
    private String knttp;

    /**
     * 条件定价单位
     */
    @JsonProperty("KPEIN")
    private BigDecimal kpein;

    /**
     *货币码
     */
    @JsonProperty("KOEIN")
    private String koein;
}
