package com.huigou.topsun.sap.exceptionReport.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/7/3016:07
 */
@Data
public class ExceptionReportPayableVo implements Serializable {

    @JsonProperty("ZEBELN")
    private String zebeln;//订单号

    @JsonProperty("WERKS")
    private String werks;  // 公厂代码 CHAR(4)

    @JsonProperty("BUKRS")
    private String bukrs;  // 公司代码 CHAR(4)

    @JsonProperty("EBELN")
    private String purchaseNo;  // 采购凭证编号 CHAR(10)

    @JsonProperty("EBELP")
    private String ebelp;  // 采购凭证的项目编号 NUMC(5)

    @JsonProperty("GJAHR")
    private String gjahr;  // 物料凭证的年份 NUMC(4)

    @JsonProperty("BELNR")
    private String belnr;  // 物料凭证编号 CHAR(10)

    @JsonProperty("BUZEI")
    private String buzei;  // 物料凭证中的项目 NUMC(4)

    @JsonProperty("MATNR")
    private String productCode;  // 物料编码 CHAR(18)

    @JsonProperty("TXZ01")
    private String productName;  // 物料描述 CHAR(40)

    @JsonProperty("BPMNG")
    private BigDecimal bpmng;  // 过账数量（订单单位） QUAN

    @JsonProperty("MEINS")
    private String unit;  // 订单单位 UNIT(3)

    @JsonProperty("MWSKZ")
    private String mwskz;  // 销售/购买税代码 CHAR(2)

    @JsonProperty("WAERS")
    private String waers;  // 货币 CUKY(5)

    @JsonProperty("ZWRBTR")
    private BigDecimal money; // 扣款金额（含税） CURR
}
