package com.huigou.topsun.sap.exceptionReport.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: lxh
 * @Date: 2024/09/12/15:05
 * @Description: 品质异常报告 责任人历史记录
 */
@Data
@Entity
@Table(name = "sap_exception_responsible")
public class ExceptionReportResponsible extends AbstractEntity {

    /**
     * 品质异常报告id
     */
    @Column(name = "exception_report_id")
    private String exceptionReportId;

    //单据编号
    @Column(name = "bill_code")
    private String billCode;

    /**
     * 责任部门
     */
    @Column(name = "duty_dept")
    private String dutyDept;

    /**
     * 责任部门名称
     */
    @Column(name = "duty_dept_name")
    private String dutyDeptName;

    /**
     * 责任人
     */
    @Column(name = "check_operator")
    private String checkOperator;

    /**
     * 责任人名称
     */
    @Column(name = "check_operator_name")
    private String checkOperatorName;


    @Column(name = "created_id")
    private String createdId;

    @Column(name = "created_name")
    private String createdName;

    @Column(name = "create_date")
    private Date createDate;

//    @Column(name = "sequence")
//    private Integer sequence;
//
    /*
     *备注
     */
    @Column(name = "remark")
    private String remark;
}
