package com.huigou.topsun.sap.exceptionReport.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReportCashApplication;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReportGoodsApplication;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportCash;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportGoods;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReportQueryRequest;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReportCashRepository;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReportGoodsRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: lxh
 * @Date: 2024/08/21/19:36
 * @Description: 品质异常报告商品赔付处理方式信息
 */
@Service("exceptionReportGoodsApplication")
public class ExceptionReportGoodsApplicationImpl extends BaseApplication implements ExceptionReportGoodsApplication {
    @Autowired
    private ExceptionReportGoodsRepository exceptionReportGoodsRepository;
    @Override
    public List<ExceptionReportGoods> findByExceptionReportId(String exceptionReportId) {
        return exceptionReportGoodsRepository.findByExceptionReportId(exceptionReportId);
    }

    @Override
    public void saveExceptionReportGoodsList(String exceptionReportId, List<ExceptionReportGoods> goodsList) {
        for (ExceptionReportGoods exceptionReportGoods : goodsList) {
            exceptionReportGoods.setExceptionReportId(exceptionReportId);
            exceptionReportGoodsRepository.save(exceptionReportGoods);
        }
    }

    @Override
    public Map<String, Object> slicedExceptionReportGoodsList(ExceptionReportQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getExceptionReportId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "exceptionReportGoods");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        for (String id : ids) {
            exceptionReportGoodsRepository.delete(id);
        }
    }

    @Override
    public void saveExceptionReportGoods(ExceptionReportGoods exceptionReportGoods) {
        exceptionReportGoodsRepository.save(exceptionReportGoods);
    }
}
