package com.huigou.topsun.sap.exceptionReport.application.impl;

import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReasonTypeDetail;
import com.huigou.topsun.sap.exceptionReport.domain.TmpExceptionReasonTypeDetail;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReasonTypeDetailRepository;
import com.huigou.topsun.sap.exceptionReport.repository.TmpExceptionReasonTypeDetailRepository;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service("reasonTypeDetailExcelImport")
public class ExceptionReasonTypeDetailExcelImport implements ExcelImportInterface {


    @Autowired
    private TmpExceptionReasonTypeDetailRepository tmpExceptionReasonTypeDetailRepository;
    @Autowired
    private ExceptionReasonTypeDetailRepository exceptionReasonTypeDetailRepository;
    @Override
    public void executeImport(String batchNumer) {
        List<TmpExceptionReasonTypeDetail> tmpExceptionReasonTypeDetails = tmpExceptionReasonTypeDetailRepository.findByBatchNumber(batchNumer);
        if (!CollectionUtils.isEmpty(tmpExceptionReasonTypeDetails)){
            for (TmpExceptionReasonTypeDetail tmpExceptionReasonTypeDetail : tmpExceptionReasonTypeDetails) {
                ExceptionReasonTypeDetail exceptionReasonTypeDetail = new ExceptionReasonTypeDetail();
                BeanUtils.copyProperties(tmpExceptionReasonTypeDetail,exceptionReasonTypeDetail);
                exceptionReasonTypeDetailRepository.save(exceptionReasonTypeDetail);
            }
        }
        System.out.println("=========================");
    }

}
