package com.huigou.topsun.sap.dull.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;

import com.huigou.topsun.sap.dull.application.SapDullItemApplication;
import com.huigou.topsun.sap.dull.domain.SapDullItem;
import com.huigou.topsun.sap.dull.domain.query.SapDullQueryRequest;
import com.huigou.topsun.sap.dull.repository.SapDullItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/07/04/10:16
 * @Description:
 */
@Service("sapDullItemItemApplication")
public class SapDullItemApplicationImpl extends BaseApplication implements SapDullItemApplication {
    @Autowired
    private SapDullItemRepository sapDullItemRepository;
    @Override
    public void saveSapDullItems(String sapDullId, List<SapDullItem> items) {
        for (SapDullItem item : items) {
            item.setSapDullId(sapDullId);
            sapDullItemRepository.save(item);
        }
    }

    @Override
    public Map<String, Object> querySapDullItems(SapDullQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapDullId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapDullItems");

            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            if (queryRequest.getSapDullId() != null) {
                queryModel.addCriteria(" and t.sap_dull_id =:sapDullId");
                queryModel.putParam("sapDullId", queryRequest.getSapDullId());
            }
           // queryModel.putDictionary("unit", DictUtil.getDictionary("SapDullUnit"));
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapDullItemRepository.delete(id);
        });
    }

    @Override
    public List<SapDullItem> findBySapDullId(String sapDullId) {
        return sapDullItemRepository.findBySapDullId(sapDullId);
    }
}
