package com.huigou.topsun.sap.costCenter.domain;

import com.huigou.topsun.common.AbstractPortalOrg;
import com.topsunit.query.annotations.Dictionary;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/13/10:42
 * @Description:
 */
@Table(name = "tmp_cost_center_data")
@Entity
@Data
public class TmpCostCenterData extends AbstractPortalOrg {

    /**
     * 成本中心编码
     */
    @Column(name = "kostl")
    private String kostl;

    /**
     * 有效截至日 默认9999.12.31
     */
    @Column(name = "datab")
    private Date datab;

    /**
     * 有效期自 默认当年1月1日
     */
    @Column(name = "datbi")
    private Date datbi;

    /**
     * 名称
     */
    @Column(name = "ktext")
    private String ktext;

    /**
     * 描述
     */
    @Column(name = "ltext")
    private String ltext;

    /**
     * 成本中心类型
     * 管理类	L
     * 销售类	V
     * 研发类	E
     * 间接生产类	G
     * 直接生产类	F
     */
    @Column(name = "kosar")
    @Dictionary("KOSAR")
    private String kosar;

    /**
     * 负责人
     */
    @Column(name = "verak")
    private String verak;

    /**
     * 层次结构范围
     */
    @Column(name = "KHINR")
    private String khinr;

    /**
     * 利润中心
     * 10001000 广州宝绅科技利润中心
     * 10001001 广州宝绅RFID利润中心
     */
    @Column(name = "prctr")
    @Dictionary("PRCTR")
    private String prctr;

    /**
     * 创建人编码
     */
    @Column(name = "created_code")
    private String createdCode;

    /**
     * 创建人名称
     */
    @Column(name = "created_name")
    private String createdName;

    /**
     * 联系方式
     */
    @Column(name = "tele_phone")
    private String telePhone;

    /**
     * 创建原因	CHAR	100	手工输入
     */
    @Column(name = "reason")
    private String reason;

}
