package com.huigou.topsun.sap.componentSupply.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.componentSupply.application.ComponentSupplyItemApplication;
import com.huigou.topsun.sap.componentSupply.repository.ComponentSupplyItemRepository;
import com.huigou.topsun.sap.componentSupply.application.ComponentSupplyItemApplication;
import com.huigou.topsun.sap.componentSupply.domain.ComponentSupplyItem;
import com.huigou.topsun.sap.componentSupply.domain.query.ComponentSupplyQueryRequest;
import com.huigou.topsun.sap.componentSupply.repository.ComponentSupplyItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/26/10:16
 * @Description:
 */
@Service("componentSupplyItemApplication")
public class ComponentSupplyItemApplicationImpl extends BaseApplication implements ComponentSupplyItemApplication {
    @Autowired
    private ComponentSupplyItemRepository componentSupplyItemRepository;
    @Override
    public void saveComponentSupplyItems(String componentSupplyId, List<ComponentSupplyItem> items) {
        for (ComponentSupplyItem item : items) {
            item.setComponentSupplyId(componentSupplyId);
            componentSupplyItemRepository.save(item);
        }
    }

    @Override
    public Map<String, Object> queryComponentSupplyItems(ComponentSupplyQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getComponentSupplyId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "componentSupplyItems");

            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            if (queryRequest.getComponentSupplyId() != null) {
                queryModel.addCriteria(" and t.component_supply_id =:componentSupplyId");
                queryModel.putParam("componentSupplyId", queryRequest.getComponentSupplyId());
            }
           // queryModel.putDictionary("unit", DictUtil.getDictionary("ComponentSupplyUnit"));
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            componentSupplyItemRepository.delete(id);
        });
    }

    @Override
    public List<ComponentSupplyItem> findByComponentSupplyId(String componentSupplyId) {
        return componentSupplyItemRepository.findByComponentSupplyId(componentSupplyId);
    }
}
