package com.huigou.topsun.sap.common.domain;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * @TableName sap_mutual_ep_log
 */
@Table(name="sap_mutual_ep_log")
@Data
@Entity
public class SapMutualEpLog implements Serializable {


    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )

    private String id;

    /**
     * 业务类型
     */
    @Column(name = "business_type")
    private String businessType;

    /**
     * 业务类型
     */
    @Column(name = "business_id")
    private String businessId;

    /**
     * 类型 成功、失败
     */
    @Column(name = "type")
    private String type;

    /**
     * 消息编号
     */
    @Column(name = "number")
    private String number;


    /**
     * 返回信息
     */
    @Column(name = "message")
    private String message;

    /**
     * 日志编号
     */
    @Column(name = "log_no")
    private String logNo;

    /**
     * 日志消息
     */
    @Column(name = "log_msg_no")
    private String logMsgNo;


    /**
     * 日志消息1
     * */
    @Column(name = "message_v1")
    private String messageV1;

    /**
     * 日志消息2
     * */
    @Column(name = "message_v2")
    private String messageV2;

    /**
     * 日志消息3
     * */
    @Column(name = "message_v3")
    private String messageV3;

    /**
     * 日志消息4
     * */
    @Column(name = "message_v4")
    private String messageV4;
    /**
     * 参数
     */
    @Column(name = "parameter")
    private String parameter;

    @Column(name = "field")
    private String field;

    @Column(name = "system_name")
    private String system;

    @Column(name = "belnr")
    private String belnr;

    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "created_date")
    private String createdDate;


    @Column(name = "sequence")
    private int sequence;

    private static final long serialVersionUID = 1L;
}