package com.huigou.topsun.sap.cashSettlementUnPay.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CashSettlementUnPayItemDetailVo implements Serializable {
    /**
     * itemId
     */
    @JsonProperty("cash_settlement_unPay_item_id")
    private String cashSettlementUnPayItemId;

    /**
     * 项次
     */
    @JsonProperty("ZCRPITM")
    private String detailNo;

    /**
     * 销售单号
     */
    @JsonProperty("VGBEL")
    private String saleNo;

    /**
     * 销售项次
     */
    @JsonProperty("VGPOS")
    private String saleDetailNo;

    /**
     * 订单类型
     */
    @JsonProperty("BEZEI")
    private String orderType;

    /**
     * 验收日期
     */
    @JsonProperty("accept_date")
    private Date acceptDate;

    /**
     * 验收单号
     */
    @JsonProperty("ZCACPTNCE")
    private String acceptNo;

    /**
     * 审核销售订单日
     */
    @JsonProperty("AUDAT")
    private Date auditDate;

    /**
     * 客户单号
     */
    @JsonProperty("BSTNK")
    private String customNo;

    /**
     * 产品类别
     */
    @JsonProperty("MATKL")
    private String productCategory;

    /**
     * 产品编码
     */
    @JsonProperty("MATNR")
    private String productCode;

    /**
     * 产品名称
     */
    @JsonProperty("MAKTX")
    private String productName;

    /**
     * 指令号
     */
    @JsonProperty("ZINSTNUM")
    private String orderNo;

    /**
     * 型体配色
     */
    @JsonProperty("ZMOLD")
    private String color;

    /**
     * 单位（客户）
     */
    @JsonProperty("ZSIZEUNITC_O")
    private String customUnit;

    /**
     * 请款量
     */
    @JsonProperty("ZCRPQTY")
    private BigDecimal applyNum;

    /**
     * 单价
     */
    @JsonProperty("ZODPRC_01")
    private BigDecimal price;

    /**
     * 是否客户确认单价
     */
    @JsonProperty("customer_confirm")
    private String customerConfirm;

    /**
     * 单重
     */
    @JsonProperty("BRGEW")
    private BigDecimal onePrice;

    /**
     * 实际金额
     */
    @JsonProperty("ZACTAMTFCV")
    private BigDecimal realAmount;

    /**
     * 应收金额
     */
//    @JsonProperty("ZACTAMTFCV")
//    private BigDecimal receivableAmount;

    /**
     * 请款重量
     */
    @JsonProperty("ZCRPWT")
    private BigDecimal applyWeight;

    /**
     * 备注
     */
    @JsonProperty("ZCITM_NOTE")
    private String remark;

    /**
     * 单价折扣%
     */
    @JsonProperty("price_discount")
    private BigDecimal priceDiscount;

    /**
     * 单价折后金额
     */
    @JsonProperty("ZCRPAMFCV")
    private BigDecimal priceDiscountAmount;

    /**
     * 是否扣款%
     */
    @JsonProperty("ZCUSDISC")
    private String isDeduction;

    /**
     * 是否增款%
     */
    @JsonProperty("ZADDPRC")
    private String isAdd;

    /**
     * 产品编码（客户）
     */
    @JsonProperty("KDMAT")
    private String customerProductCode;

    /**
     * 产品名称（客户）
     */
    @JsonProperty("ARKTX")
    private String customerProductName;

    /**
     * 跟单员
     */
    @JsonProperty("ZOROWNNM")
    private String salesman;

    /**
     * 预收单号
     */
    @JsonProperty("advance_receipt_no")
    private String  advanceReceiptNo;

}