package com.huigou.topsun.sap.cashSettlementUnPay.application;


import com.huigou.topsun.sap.cashSettlementUnPay.domain.CashSettlementUnPayItemDetail;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.query.CashSettlementUnPayQueryRequest;
import com.huigou.topsun.sap.cashSettlementUnPay.vo.CashSettlementUnPayItemDetailVo;
import com.huigou.topsun.sap.cashSettlementUnPay.vo.CashSettlementUnPayItemVo;

import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/26/10:35
 * @Description:
 */
public interface CashSettlementUnPayItemDetailApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/sap/cashSettlementUnPay/cashSettlementUnPay.xml";
    void saveCashSettlementUnPayItemDetails(String cashSettlementUnPayItemId, List<CashSettlementUnPayItemDetail> items);

    void saveCashSettlementUnPayItemDetail(CashSettlementUnPayItemDetail detail);
    Map<String,Object> queryCashSettlementUnPayItemDetails(CashSettlementUnPayQueryRequest queryRequest);

    void deleteByCashSettlementUnPayItemId(String cashSettlementUnPayItemId);

    List<CashSettlementUnPayItemDetail> findByCashSettlementUnPayItemId(String cashSettlementUnPayItemId);

    List<CashSettlementUnPayItemDetailVo> getItemDetailsByAdvanceReceiptNo(String advanceReceiptNo);
    CashSettlementUnPayItemVo getItemByAdvanceReceiptNo(String advanceReceiptNo);

    List<CashSettlementUnPayItemDetailVo> getItemDetailsByAdvanceReceiptNoOrSaleNo(String advanceReceiptNo, String saleNo);

    List<Map<String, String>> getAdvanceReceiptNo(String customerCode);
}
