package com.huigou.topsun.sap.acceptanceFormAck.domain;

import java.io.Serializable;

import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.*;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @author YourUserName
 * null
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "sap_acceptance_form_ack")
public class SapAcceptanceFormAck implements Serializable {

	/**
	 * null
	 */
	@Id
	@Column(name = "uuid", nullable = false, length = 32)
	private String uuid;

	/**
	 * 客户系统验收标记
	 */
	@Column(name = "ZACFMK", nullable = true, length = 1)
	private String zacfmk;

	/**
	 * 销售凭证 
	 */
	@Column(name = "VGBEL", nullable = true, length = 10)
	private String vgbel;

	/**
	 * 销售凭证项目 
	 */
	@Column(name = "VGPOS", nullable = true, length = 6)
	private String vgpos;

	/**
	 * 物料编号
	 */
	@Column(name = "MATNR", nullable = true, length = 40)
	private String matnr;

	/**
	 * 物料描述
	 */
	@Column(name = "MAKTX", nullable = true, length = 40)
	private String maktx;

	/**
	 * 销售和分销凭证号 
	 */
	@Column(name = "VBELN", nullable = true, length = 10)
	private String vbeln;

	/**
	 * 销售和分销凭证的项目号
	 */
	@Column(name = "POSNR", nullable = true, length = 8)
	private String posnr;

	/**
	 * 销售组织
	 */
	@Column(name = "VKORG", nullable = true, length = 4)
	private String vkorg;

	/**
	 * 售达方
	 */
	@Column(name = "KUNAG", nullable = true, length = 10)
	private String kunag;

	/**
	 * 名称
	 */
	@Column(name = "NAME1", nullable = true, length = 30)
	private String name1;

	/**
	 * 请款联
	 */
	@Column(name = "KATR6", nullable = true, length = 2)
	private String katr6;

	/**
	 * 交货日期
	 */
	@JsonFormat(pattern = "yyyyMMdd")
	@Column(name = "LFDAT", nullable = true)
	private java.util.Date lfdat;

	/**
	 * 客户编号
	 */
	@Column(name = "ZHDLR", nullable = true, length = 12)
	private String zhdlr;

	/**
	 * 名称
	 */
	@Column(name = "ZHDNM", nullable = true, length = 30)
	private String zhdnm;

	/**
	 * 验收单标记人
	 */
	@Column(name = "ZMKP4", nullable = true, length = 32)
	private String zmkp4;

	/**
	 * 验收单标记时间
	 */
	@JsonFormat(pattern = "yyyyMMdd")
	@Column(name = "ZMKT4", nullable = true)
	private java.util.Date zmkt4;

	/**
	 * 验收单业务标记 
	 */
	@Column(name = "ZACSMK", nullable = true, length = 1)
	private String zacsmk;

	/**
	 * 验收单业务标记人
	 */
	@Column(name = "ZMKP5", nullable = true, length = 12)
	private String zmkp5;

	/**
	 * 验收单业务标记时间
	 */
	@JsonFormat(pattern = "yyyyMMdd")
	@Column(name = "ZMKT5", nullable = true)
	private java.util.Date zmkt5;

	/**
	 * 客户物料
	 */
	@Column(name = "KDMAT", nullable = true, length = 35)
	private String kdmat;

	/**
	 * 参考的描述
	 */
	@Column(name = "POSTX", nullable = true, length = 40)
	private String postx;

	/**
	 * 客户参考
	 */
	@Column(name = "BSTKD", nullable = true, length = 35)
	private String bstkd;

	/**
	 * 指令号 
	 */
	@Column(name = "ZINSN", nullable = true, length = 30)
	private String zinsn;

	/**
	 * 型体号 
	 */
	@Column(name = "ZMOLD", nullable = true, length = 30)
	private String zmold;

	/**
	 * 配色号 
	 */
	@Column(name = "ZMAPCOLOR", nullable = true, length = 30)
	private String zmapcolor;

	/**
	 * 段别
	 */
	@Column(name = "ZSEGM", nullable = true, length = 10)
	private String zsegm;

	/**
	 * 实际已交货量（按销售单位）
	 */
	@Column(name = "LFIMG", nullable = true, length = 33)
	private String lfimg;

	/**
	 * 以销售单位表示的累计订购数量
	 */
	@Column(name = "KWMENG", nullable = true, length = 33)
	private String kwmeng;

	/**
	 * 请款数量
	 */
	@Column(name = "ZCORQT", nullable = true, length = 20)
	private String zcorqt;

	/**
	 * 销售单位
	 */
	@Column(name = "VRKME", nullable = true, length = 6)
	private String vrkme;

	/**
	 * 净价
	 */
	@Column(name = "NETPR", nullable = true, length = 22)
	private String netpr;

	/**
	 * SD 凭证货币
	 */
	@Column(name = "WAERK", nullable = true, length = 20)
	private String waerk;

	/**
	 * 备注
	 */
	@Column(name = "ZCNOTE", nullable = true, length = 255)
	private String zcnote;

	/**
	 * 请款单号
	 */
	@Column(name = "ZCRNR", nullable = true, length = 12)
	private String zcrnr;

	/**
	 * 请款单项次
	 */
	@Column(name = "ZCRITM", nullable = true, length = 20)
	private String zcritm;

	/**
	 * 做账人
	 */
	@Column(name = "ZCRRSP", nullable = true, length = 16)
	private String zcrrsp;

	/**
	 * 做账时间
	 */
	@JsonFormat(pattern = "yyyyMMdd")
	@Column(name = "ZCTIME", nullable = true)
	private java.util.Date zctime;

	@Override
	public boolean equals(Object o) {
		if (this == o) { return true; }
		if (o == null || getClass() != o.getClass()) { return false; }
		SapAcceptanceFormAck that = (SapAcceptanceFormAck) o;
		return Objects.equals(uuid, that.uuid) && Objects.equals(zacfmk, that.zacfmk) && Objects.equals(vgbel, that.vgbel) && Objects.equals(vgpos, that.vgpos) && Objects.equals(matnr, that.matnr) && Objects.equals(maktx, that.maktx) && Objects.equals(vbeln, that.vbeln) && Objects.equals(posnr, that.posnr) && Objects.equals(vkorg, that.vkorg) && Objects.equals(kunag, that.kunag) && Objects.equals(name1, that.name1) && Objects.equals(katr6, that.katr6) && Objects.equals(lfdat, that.lfdat) && Objects.equals(zhdlr, that.zhdlr) && Objects.equals(zhdnm, that.zhdnm) && Objects.equals(zmkp4, that.zmkp4) && Objects.equals(zmkt4, that.zmkt4) && Objects.equals(zacsmk, that.zacsmk) && Objects.equals(zmkp5, that.zmkp5) && Objects.equals(zmkt5, that.zmkt5) && Objects.equals(kdmat, that.kdmat) && Objects.equals(postx, that.postx) && Objects.equals(bstkd, that.bstkd) && Objects.equals(zinsn, that.zinsn) && Objects.equals(zmold, that.zmold) && Objects.equals(zmapcolor, that.zmapcolor) && Objects.equals(zsegm, that.zsegm) && Objects.equals(lfimg, that.lfimg) && Objects.equals(kwmeng, that.kwmeng) && Objects.equals(zcorqt, that.zcorqt) && Objects.equals(vrkme, that.vrkme) && Objects.equals(netpr, that.netpr) && Objects.equals(waerk, that.waerk) && Objects.equals(zcnote, that.zcnote) && Objects.equals(zcrnr, that.zcrnr) && Objects.equals(zcritm, that.zcritm) && Objects.equals(zcrrsp, that.zcrrsp) && Objects.equals(zctime, that.zctime);
	}

	@Override
	public int hashCode() {
		return Objects.hash(uuid, zacfmk, vgbel, vgpos, matnr, maktx, vbeln, posnr, vkorg, kunag, name1, katr6, lfdat, zhdlr, zhdnm, zmkp4, zmkt4, zacsmk, zmkp5, zmkt5, kdmat, postx, bstkd, zinsn, zmold, zmapcolor, zsegm, lfimg, kwmeng, zcorqt, vrkme, netpr, waerk, zcnote, zcrnr, zcritm, zcrrsp, zctime);
	}

	public String getUuid() {
		return this.uuid;
	}
	
	public void setUuid(String uuid) {
		this.uuid = uuid;
	}
	
	public String getZacfmk() {
		return this.zacfmk;
	}
	
	public void setZacfmk(String zacfmk) {
		this.zacfmk = zacfmk;
	}
	
	public String getVgbel() {
		return this.vgbel;
	}
	
	public void setVgbel(String vgbel) {
		this.vgbel = vgbel;
	}
	
	public String getVgpos() {
		return this.vgpos;
	}
	
	public void setVgpos(String vgpos) {
		this.vgpos = vgpos;
	}
	
	public String getMatnr() {
		return this.matnr;
	}
	
	public void setMatnr(String matnr) {
		this.matnr = matnr;
	}
	
	public String getMaktx() {
		return this.maktx;
	}
	
	public void setMaktx(String maktx) {
		this.maktx = maktx;
	}
	
	public String getVbeln() {
		return this.vbeln;
	}
	
	public void setVbeln(String vbeln) {
		this.vbeln = vbeln;
	}
	
	public String getPosnr() {
		return this.posnr;
	}
	
	public void setPosnr(String posnr) {
		this.posnr = posnr;
	}
	
	public String getVkorg() {
		return this.vkorg;
	}
	
	public void setVkorg(String vkorg) {
		this.vkorg = vkorg;
	}
	
	public String getKunag() {
		return this.kunag;
	}
	
	public void setKunag(String kunag) {
		this.kunag = kunag;
	}
	
	public String getName1() {
		return this.name1;
	}
	
	public void setName1(String name1) {
		this.name1 = name1;
	}
	
	public String getKatr6() {
		return this.katr6;
	}
	
	public void setKatr6(String katr6) {
		this.katr6 = katr6;
	}
	
	public java.util.Date getLfdat() {
		return this.lfdat;
	}
	
	public void setLfdat(java.util.Date lfdat) {
		this.lfdat = lfdat;
	}
	
	public String getZhdlr() {
		return this.zhdlr;
	}
	
	public void setZhdlr(String zhdlr) {
		this.zhdlr = zhdlr;
	}
	
	public String getZhdnm() {
		return this.zhdnm;
	}
	
	public void setZhdnm(String zhdnm) {
		this.zhdnm = zhdnm;
	}
	
	public String getZmkp4() {
		return this.zmkp4;
	}
	
	public void setZmkp4(String zmkp4) {
		this.zmkp4 = zmkp4;
	}
	
	public java.util.Date getZmkt4() {
		return this.zmkt4;
	}
	
	public void setZmkt4(java.util.Date zmkt4) {
		this.zmkt4 = zmkt4;
	}
	
	public String getZacsmk() {
		return this.zacsmk;
	}
	
	public void setZacsmk(String zacsmk) {
		this.zacsmk = zacsmk;
	}
	
	public String getZmkp5() {
		return this.zmkp5;
	}
	
	public void setZmkp5(String zmkp5) {
		this.zmkp5 = zmkp5;
	}
	
	public java.util.Date getZmkt5() {
		return this.zmkt5;
	}
	
	public void setZmkt5(java.util.Date zmkt5) {
		this.zmkt5 = zmkt5;
	}
	
	public String getKdmat() {
		return this.kdmat;
	}
	
	public void setKdmat(String kdmat) {
		this.kdmat = kdmat;
	}
	
	public String getPostx() {
		return this.postx;
	}
	
	public void setPostx(String postx) {
		this.postx = postx;
	}
	
	public String getBstkd() {
		return this.bstkd;
	}
	
	public void setBstkd(String bstkd) {
		this.bstkd = bstkd;
	}
	
	public String getZinsn() {
		return this.zinsn;
	}
	
	public void setZinsn(String zinsn) {
		this.zinsn = zinsn;
	}
	
	public String getZmold() {
		return this.zmold;
	}
	
	public void setZmold(String zmold) {
		this.zmold = zmold;
	}
	
	public String getZmapcolor() {
		return this.zmapcolor;
	}
	
	public void setZmapcolor(String zmapcolor) {
		this.zmapcolor = zmapcolor;
	}
	
	public String getZsegm() {
		return this.zsegm;
	}
	
	public void setZsegm(String zsegm) {
		this.zsegm = zsegm;
	}
	
	public String getLfimg() {
		return this.lfimg;
	}
	
	public void setLfimg(String lfimg) {
		this.lfimg = lfimg;
	}
	
	public String getKwmeng() {
		return this.kwmeng;
	}
	
	public void setKwmeng(String kwmeng) {
		this.kwmeng = kwmeng;
	}
	
	public String getZcorqt() {
		return this.zcorqt;
	}
	
	public void setZcorqt(String zcorqt) {
		this.zcorqt = zcorqt;
	}
	
	public String getVrkme() {
		return this.vrkme;
	}
	
	public void setVrkme(String vrkme) {
		this.vrkme = vrkme;
	}
	
	public String getNetpr() {
		return this.netpr;
	}
	
	public void setNetpr(String netpr) {
		this.netpr = netpr;
	}
	
	public String getWaerk() {
		return this.waerk;
	}
	
	public void setWaerk(String waerk) {
		this.waerk = waerk;
	}
	
	public String getZcnote() {
		return this.zcnote;
	}
	
	public void setZcnote(String zcnote) {
		this.zcnote = zcnote;
	}
	
	public String getZcrnr() {
		return this.zcrnr;
	}
	
	public void setZcrnr(String zcrnr) {
		this.zcrnr = zcrnr;
	}
	
	public String getZcritm() {
		return this.zcritm;
	}
	
	public void setZcritm(String zcritm) {
		this.zcritm = zcritm;
	}
	
	public String getZcrrsp() {
		return this.zcrrsp;
	}
	
	public void setZcrrsp(String zcrrsp) {
		this.zcrrsp = zcrrsp;
	}
	
	public java.util.Date getZctime() {
		return this.zctime;
	}
	
	public void setZctime(java.util.Date zctime) {
		this.zctime = zctime;
	}
}
