package com.huigou.topsun.mes.unqualifiedMaterials.domain.query;

import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import java.util.Calendar;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/12/10:26
 * @Description:
 */
@Data
public class UnqualifiedMaterialsQueryRequest extends QueryAbstractRequest {
    private String billCode;
    private String pd;
    private String batchNo;
    protected Date fillinBeginDate;

    protected Date fillinEndDate;

    public Date getFillinEndDate() {
        return fillinEndDate;
    }

    public void setFillinEndDate(Date fillinEndDate) {
        if (fillinEndDate != null) {
            // 使用Calendar类给日期加一天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fillinEndDate);
            calendar.add(Calendar.DATE, 1); // 给日期加上一天
            // 获取新的Date对象
            fillinEndDate = calendar.getTime();
        }
        this.fillinEndDate = fillinEndDate;
    }
}
