package com.huigou.topsun.mes.unqualifiedMaterials.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.data.domain.query.CodeAndNameQueryRequest;
import com.huigou.topsun.mes.unqualifiedMaterials.application.UnqualifiedMaterialsApplication;
import com.huigou.topsun.mes.unqualifiedMaterials.domain.UnqualifiedMaterials;
import com.huigou.topsun.mes.unqualifiedMaterials.domain.UnqualifiedMaterialsItem;
import com.huigou.topsun.mes.unqualifiedMaterials.domain.query.UnqualifiedMaterialsQueryRequest;
import com.huigou.topsun.mes.unqualifiedMaterials.domain.vo.UnqualifiedMaterialsVo;
import com.huigou.topsun.mes.unqualifiedMaterials.repository.UnqualifiedMaterialsItemRepository;
import com.huigou.topsun.mes.unqualifiedMaterials.repository.UnqualifiedMaterialsRepository;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.ClassHelper;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/12/10:30
 * @Description:
 */
@Controller
@ControllerMapping("/unqualifiedMaterials")
public class UnqualifiedMaterialsController extends CommonController {
    private final static Logger LOG = LoggerFactory.getLogger(UnqualifiedMaterialsController.class);
    @Autowired
    private UnqualifiedMaterialsApplication unqualifiedMaterialsApplication;
    @Autowired
    private UnqualifiedMaterialsItemRepository unqualifiedMaterialsItemRepository;
    @Override
    protected String getPagePath() {
        return "/biz/topsun/mes/unqualifiedMaterials/";
    }

    public String forwardUnqualifiedMaterialsList(){
        return forward("unqualifiedMaterialsList");
    }

    @SkipAuth
    @RequestMapping( value = "/getMesUnqualifiedMaterials")
    @ResponseBody
    public HashMap<String, Object> getMesUnqualifiedMaterials(@RequestBody UnqualifiedMaterialsVo unqualifiedMaterialsVo){
        //SDO sdo = this.getSDO();
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("Message_Status","S");
        messageMap.put("Message_Text","成功");
        LOG.info("MES质量异常评审表审批数据=={}", JSONUtil.toString(unqualifiedMaterialsVo));
        try {
            this.unqualifiedMaterialsApplication.saveMesUnqualifiedMaterialsVo(unqualifiedMaterialsVo);
        }catch (RuntimeException e){
            messageMap.put("Message_Status","E");
            messageMap.put("Message_Text",e.getMessage());
        }finally {
            LOG.info("MES质量异常评审表返回数据=={}", JSONUtil.toString(messageMap));
        }
        return messageMap;
    }

    public String slicedUnqualifiedMaterialsList(){
        SDO sdo = this.getSDO();
        UnqualifiedMaterialsQueryRequest queryRequest = sdo.toQueryRequest(UnqualifiedMaterialsQueryRequest.class);
        Map<String, Object> map = unqualifiedMaterialsApplication.slicedUnqualifiedMaterialsList(queryRequest);
        return toResult(map);
    }

    public String forwardUnqualifiedMaterialsDetail(){
        this.putAttribute("processDefinitionKey", UnqualifiedMaterialsApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        UnqualifiedMaterials unqualifiedMaterials = new UnqualifiedMaterials();
        unqualifiedMaterials.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        unqualifiedMaterials.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("unqualifiedMaterialsDetail",unqualifiedMaterials);
    }

    public String showUnqualifiedMaterialsDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        UnqualifiedMaterials unqualifiedMaterials = unqualifiedMaterialsApplication.findUnqualifiedMaterialsById(id);
        return forward("unqualifiedMaterialsDetail",unqualifiedMaterials);
    }

    public String uploadFile(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        this.putAttribute("bizId",id);
        return forward("attachment");
    }

    /**
     * 打印
     * @return
     */
    public String print() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        UnqualifiedMaterials unqualifiedMaterials = this.unqualifiedMaterialsApplication.findUnqualifiedMaterialsById(id);
        Map<String, Object> map = ClassHelper.beanToMap(unqualifiedMaterials);
        List<UnqualifiedMaterialsItem> materialsItemList = this.unqualifiedMaterialsItemRepository.findByUnqualifiedMaterialsId(unqualifiedMaterials.getId());
        map.put("items",materialsItemList);
        map.put("printTime", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").format(LocalDateTime.now()));
        String pintPage = String.format("/print/topsun/unqualifiedMaterials.ftl");
        return outputAndProcUnitHandlerPDF(pintPage, id, map);
    }

    public String slicedQueryUserGroupDetails() {
        SDO params = this.getSDO();
        String paramValue = params.getString("paramValue");
        CodeAndNameQueryRequest queryRequest = params.toQueryRequest(CodeAndNameQueryRequest.class);
        if (StringUtil.isNotBlank(paramValue)){
            queryRequest.setName(paramValue);
        }
        Map<String, Object> map = unqualifiedMaterialsApplication.slicedQueryUserGroupAllDetails(queryRequest);
        return toResult(map);
    }

}
