package com.huigou.topsun.mes.produceException.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/12/10:25
 * @Description: 生产异常
 */
@Entity
@Data
@Table(name = "mes_produce_exception")
public class ProduceException extends FlowBillAbstractEntity {

    /**
     * 异常单号
     */
    @Column(name = "exception_no")
    private String exceptionNo;

    /**
     * 编排单号
     */
    @Column(name = "layout_no")
    private String layoutNo;

    /**
     * 工序名称
     */
    @Column(name = "process")
    private String process;

    /**
     * 工作中心名称
     */
    @Column(name = "worker_center")
    private String workerCenter;

    /**
     * 作业单元名称
     */
    @Column(name = "worker_unit")
    private String workerUnit;
    
    /**
     * 物料号
     */
    @Column(name = "material_no")
    private String materialNo;

    /**
     * 物料名称
     */
    @Column(name = "material_name")
    private String materialName;

    /**
     * 异常类型
     */
    @Column(name = "exception_type")
    private String exceptionType;

    /**
     * 异常原因
     */
    @Column(name = "exception_reason")
    private String exceptionReason;

    /**
     * 异常描述
     */
    @Column(name = "exception_desc")
    private String exceptionDesc;

    /**
     * 异常时间
     */
    @Column(name = "exception_date")
    private Date exceptionDate;

    /**
     * 提交人
     */
    @Column(name = "submitter")
    private String submitter;

    /**
     * 提交人
     */
    @Column(name = "submitter_name")
    private String submitterName;

    /**
     * 审批人编码
     */
    @Column(name = "approval_code")
    private String approvalCode;

    /**
     * 审批人名称
     */
    @Column(name = "approval_name")
    private String approvalName;

    /**
     * 处理结果
     */
    @Column(name = "result")
    private String result;

    /**
     * MES返回状态码
     */
    @Column(name = "code")
    private String code;

    /**
     * MES返回消息
     */
    @Column(name = "msg")
    private String msg;

    public String getMaterialNo() {
        return materialNo.replaceAll("^(0+)", "");
    }

    public void setMaterialNo(String materialNo) {
        String s = materialNo.replaceAll("^(0+)", "");
        this.materialNo = s;
    }

    @Override
    protected String getCodeRuleId() {
        return "produceException";
    }
}
