package com.huigou.topsun.ep.order.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/17:21
 * @Description: EP销售订单明细
 */
@Data
@Entity
@Table(name = "ep_sale_order_item")
public class EpSaleOrderItem extends AbstractEntity {
    /**
     * EP销售订单id
     */
    @Column(name = "ep_sale_order_id")
    private String epSaleOrderId;

    /**
     * 订单原因（业务交易原因）
     */
    @Column(name = "AUGRU")
    private String augru;

    /**
     * 订单编号
     */
    @Column(name = "VBELN")
    private String vbeln;

    /**
     * 订单总金额
     */
    @Column(name = "NETWR")
    private BigDecimal netwr;

    /**
     * 总额
     */
    @Column(name = "amount")
    private BigDecimal amount;

    /**
     * 客户采购单号
     */
    @Column(name = "BSTNK")
    private String bstnk;

    /**
     * 销售凭证项目
     */
    @Column(name = "POSNR")
    private String posnr;

    /**
     * 物料编号
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     * 物料描述
     */
    @Column(name = "MAKTX")
    private String maktx;

    /**
     * 订单数量
     */
    @Column(name = "KWMENG")
    private BigDecimal kwmeng;

    /**
     * 销售单位
     */
    @Column(name = "VRKME")
    private String vrkme;

    /**
     * 价格
     */
    @Column(name = "VA_KBETR")
    private BigDecimal vaKbetr;

    /**
         * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    /**
     * 指令号
     */
    @Column(name = "ZINSTNUM")
    private String zinstnum;

    /**
     * 型体号
     */
    @Column(name = "ZMOLD")
    private String zmold;

    /**
     * 配色号
     */
    @Column(name = "ZMAPCOLOR")
    private String zmapcolor;

    /**
     * 品牌
     */
    @Column(name = "MVGR1")
    private String mvgr1;

    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;

    /**
     * 跟单员
     */
    @Column(name = "merchandiser")
    private String merchandiser;

    /**
     * 跟单员
     */
    @Column(name = "merchandiser_name")
    private String merchandiserName;

    /**
     * 生产工单
     */
    @Column(name = "workorder_code")
    private String workorderCode;
}
