package com.huigou.topsun.ep.order.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/17:21
 * @Description: EP销售订单取消/变更明细
 */
@Data
@Entity
@Table(name = "ep_sale_order_cancel_item")
public class EpSaleOrderCancelItem extends AbstractEntity {
    /**
     * EP销售订单id
     */
    @Column(name = "ep_sale_order_cancel_id")
    private String epSaleOrderCancelId;

    /**
     * 销售单号
     */
    @Column(name = "VBELN")
    private String vbeln;

    /**
     * 销售凭证项目
     */
    @Column(name = "POSNR")
    private String posnr;

    /**
     * 物料编号
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     * 物料描述
     */
    @Column(name = "MAKTX")
    private String maktx;

    /**
     * 订单数量
     */
    @Column(name = "KWMENG")
    private BigDecimal kwmeng;

    /**
     * 销售单位
     */
    @Column(name = "VRKME")
    private String vrkme;

    /**
     * 生产单号
     */
    @Column(name = "PRODUCE_CODE")
    private String produceCode;

    /**
     * 工序
     */
    @Column(name = "PROCESS")
    private String process;

    /**
     * 单价
     */
    @Column(name = "price")
    private BigDecimal price;

    /**
     * 总价
     */
    @Column(name = "amount")
    private BigDecimal amount;

    /**
     * 跟单员
     */
    @Column(name = "merchandiser")
    private String merchandiser;

    /**
     * 跟单员
     */
    @Column(name = "merchandiser_name")
    private String merchandiserName;

}
