package com.huigou.topsun.ep.order.controller;

import com.huigou.topsun.ep.order.application.EpSaleOrderItemApplication;
import com.huigou.topsun.ep.order.domain.query.EpSaleOrderQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/19:14
 * @Description:
 */
@Controller
@ControllerMapping("/epSaleOrderItem")
public class EpSaleOrderItemController extends CommonController {
    @Resource
    private EpSaleOrderItemApplication epSaleOrderItemApplication;

    public String queryEpSaleOrderItems(){
        SDO sdo = this.getSDO();
        EpSaleOrderQueryRequest queryRequest = sdo.toQueryRequest(EpSaleOrderQueryRequest.class);
        Map<String, Object> map = epSaleOrderItemApplication.queryEpSaleOrderItems(queryRequest);
        return toResult(map);
    }

    public String deleteEpSaleOrderItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        epSaleOrderItemApplication.deleteByIds(ids);
        return success();
    }
}
