package com.huigou.topsun.ep.controller;

import com.huigou.topsun.ep.epApplication.EpApplication;
import com.huigou.topsun.sap.sapApplication.application.SapDictionaryApplication;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.easysearch.EasySearch;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/22/15:35
 * @Description: easySearch方式查询EP系统数据
 */
@Controller
@ControllerMapping("/epResourceSearch")
public class EpResourceSearchController {
    @Autowired
    private EpApplication epApplication;
    @Autowired
    private SapDictionaryApplication sapDictionaryApplication;

    @EasySearch(queryName = "queryBrand")
    public Map<String, Object> queryBrand(SDO sdo) throws IOException {
        String param = sdo.getString("paramValue");
//        if (StringUtil.isNotBlank(param)){
//            param = param.toUpperCase();
//        }
        List<Map<String, String>> mapList = new ArrayList<>();
        mapList = epApplication.queryEpBrand(param);
        return sapDictionaryApplication.initEasySearchModel( mapList, param, sdo);
    }

    @EasySearch(queryName = "queryPd")
    public Map<String, Object> queryPd(SDO sdo) throws IOException {
        String param = sdo.getString("paramValue");
        String filterValue = sdo.getString("filterValue");
        List<Map<String, String>> mapList = new ArrayList<>();
        mapList = epApplication.queryEpPd(filterValue);
        if (!CollectionUtils.isEmpty(mapList)){
            mapList = mapList
                    .stream()
                    .map(p -> {
                        String productCode = p.get("productCode");
                        if (p.get("sapProductCode")!=null){
                            productCode = productCode + "/" + p.get("sapProductCode");
                        }
                        p.put("productCode",productCode);
                        p.remove("sapProductCode");
                        return p;
                    }).collect(Collectors.toList());
        }
        return sapDictionaryApplication.initEasySearchModel( mapList, param, sdo);
    }

    @EasySearch(queryName = "queryProductAndBom")
    public Map<String, Object> queryProductAndBom(SDO sdo) throws IOException {
        String param = sdo.getString("paramValue");
        String filterValue = sdo.getString("filterValue");
        List<Map<String, String>> mapList = new ArrayList<>();
        mapList = epApplication.queryProductAndBom(filterValue);
        return sapDictionaryApplication.initEasySearchModel( mapList, param, sdo);
    }
}
