var gridManager = null;

$(document).ready(function () {
    initializateUI()
    loadNonProdApplyListGrid();
    initBasicInfoMaintenance();
    bindEvent();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}
function loadNonProdApplyListGrid() {

    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function (){
            addHandler()
        },
        deleteHandler: deleteHandler,
        testHandler: {id: 'basicInfoMaintenance', text: '信息填报', img: 'fa-music', className: 'btn-gray',
            click: function () {

                let result=DataUtil.getUpdateRow(gridManager);
                if(result.status!==3){
                    Public.tip("请选择一条已审核后数据！")
                    return false;
                }
                var url = '/sapNonProdApplyNext/forwardNonProdApplyNext.do?bizId='+result.id;
                if (result.deptStatus == 1){
                    url = '/sapNonProdApplyNext/forwardNonProdApplyNext.do?isReadOnly=true&bizId='+result.id;
                }

                UICtrl.addTabItem({
                    tabid: 'showNonProdApplyNext'+result.id,
                    text: "非产品/非半成品类物料主数据维护申请详情",
                    url: web_app.name + url
                });
            }
        },
        modifyHandler: {id: 'modifyData', text: '变更', img: 'fa-building-o', className: 'btn-gray',
            click: function () {

                let result=DataUtil.getUpdateRow(gridManager);
                if(result.status!==3){
                    Public.tip("请选择一条已审核后数据！")
                    return false;
                }
                if(result.distribute!==2){
                    Public.tip("请选择一条已办结的数据！")
                    return false;
                }
                modifyHandler(result.id,result.matnr);
                //publishDatas('确实要发布数据吗?', result.id);
            }
        },
        extendedHandler: {id: 'extendedData', text: '扩展', img: 'fa-qrcode', className: 'btn-gray',
            click: function () {

                let result=DataUtil.getUpdateRow(gridManager);
                if(result.status!==3){
                    Public.tip("请选择一条已审核后数据！")
                    return false;
                }
                if(result.distribute!==2){
                    Public.tip("请选择一条已办结的数据！")
                    return false;
                }
                extendedHandler(result.id,result.matnr);;
            }
        },
        impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},
        exportExcelHandler:exportExcelHandler,
        unfreezeHandler: {id: 'unfreeze', text: '解冻', img: 'fa-map', className: 'btn-gray',
            click: function () {
                let results = gridManager.getSelectedRows();
                var ids = [];
                for (var i = 0; i < results.length; i++) {
                    var item = results[i];
                    if (item.distribute != "2"){
                        Public.tip("请选择一条已办结的数据！")
                        return false;
                    }
                    ids.push(item.id);
                }
                UICtrl.confirm('您确定要解冻吗?', function () {
                    Public.ajax(web_app.name + '/sapNonProdApplyNext/markMaterialStatus.ajax',
                        {ids: $.toJSON(ids)},
                        function () {
                            reloadGrid();
                        });
                });
            }
        }
    });
    gridManager = UICtrl.grid("#nonProdApplyListGrid", {
        columns: [
            {display: "申请单编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "申请状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "申请日期", name: "createdDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "类型", name: "kind", width: 80, minWidth: 60, type: "string", align: "left",
                render:function(item){
                    var type = "物料";
                    if (item.kind === "product"){
                        type="产品";
                    }
                    return type;
                }
            },
            {display: "工厂", name: "werksName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "物料/产品编码", name: "matnr", width: 150, minWidth: 60, type: "string", align: "left",
                render:function(item){
                    return item.matnr.replace(/^0+/, '');
                }
            },
            {display: "维护类型", name: "maintenanceTypeTextView", width: 130, minWidth: 60, type: "string", align: "left",
                render:function(item){
                    var result = item.maintenanceTypeTextView+"-待填报";
                    if (item.status=="1"){
                        result=item.maintenanceTypeTextView+"-待审批";
                     }
                    if (item.distribute == "1"){
                        result=item.maintenanceTypeTextView+"-待确认";
                    }
                    if (item.distribute == "2"){
                        result=item.maintenanceTypeTextView+"-已办结";
                    }
                    return result;
                }
            },
            {display: "通用品名", name: "genericName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "SAP物料名称", name: "maktx", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "物料要求描述", name: "maktxRemZh", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "适用标准(国标)", name: "applicableStandard", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "基本计量单位", name: "meinsName", width: 80, minWidth: 60, type: "string", align: "left"},
            {display: "规格", name: "specifications", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "材质", name: "material", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "版式", name: "design", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "尺码", name: "size", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "品牌", name: "brand", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "用途", name: "materialUsage", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "物品类型", name: "mtartTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "业务用途", name: "businessUsageTextView", width: 300, minWidth: 60, type: "string", align: "left"},
            {display: "文本说明", name: "textDescription", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "批准人", name: "approver", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "批准日期", name: "approvalDate", width: 140, minWidth: 60, type: "date", align: "left"},
            {display: "申请人", name: "personMemberName", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
           /* {display: "是否分发", name: "distribute", width: 80, minWidth: 60, type: "string", align: "left",
                render:function(item){
                    var result = "待处理";
                    if (item.distribute == "1"){
                        result="待分发";
                    }
                    if (item.distribute == "2"){
                        result="已分发";
                    }
                    if (item.distribute == "3"){
                        result="已办结";
                    }
                    return result;
                }
            },*/
        ],
        dataAction: "server",
        _tableKey: 'sapNonProdApply',
        _local: true,
        url: web_app.name + '/sapNonProdApply/slicedNonProdApplyList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        async: false,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id,data.maintenanceType);
        },
        onAfterShowData: function (data){
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function initBasicInfoMaintenance(){
    //如果是货源专员角色，显示信息填报、解冻按钮
    var roleCode = $("#roleCode").val();
    if (roleCode.indexOf('hyzy') > -1){
        $("#toolbar_menubasicInfoMaintenance").show()
        $("#toolbar_menuunfreeze").show()
    }else {
        $("#toolbar_menubasicInfoMaintenance").hide()
        $("#toolbar_menuunfreeze").hide()
    }
}


function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function bindEvent() {
    //工厂
    $('#werksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            $('#werks').val(data.WERKS);
            $('#werksName').val(data.NAME1);
        }
    });
}


//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapNonProdApply/deleteNonProdApply.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'nonProdApply',
        text: "非产品/非半成品类物料主数据维护申请",
        url: web_app.name + '/sapNonProdApply/forwardNonProdApplyDetail.job'
    });
}

function doView(id,maintenanceType) {
    var title="维护申请";
    if (maintenanceType=="modify"){
        title="变更申请";
    } else if (maintenanceType=="extend") {
        title="扩展申请";
    }
    UICtrl.addTabItem({
        tabid: 'showNonProdApply'+id,
        text: "非产品/非半成品类物料主数据"+title+"详情",
        url: web_app.name + '/sapNonProdApply/showNonProdApply.job?isReadOnly=true&bizId='+id+"&isDetailPage=true"
    });
}
//变更
function modifyHandler(id,matnr) {
    if (matnr==""){
        Public.tip('当前数据没有物料编码，不能变更!');
        return false;
    }
    UICtrl.addTabItem({
        tabid: 'nonProdApplyChange'+id,
        text: "非产品/非半成品类物料主数据变更申请",
        url: web_app.name + '/sapNonProdApply/forwardNonProdApplyDetail.job?bizId='+id+"&modify=1"
    });
}
//扩展
function extendedHandler(id,matnr) {
    if (matnr==""){
        Public.tip('当前数据没有物料编码，不能扩展!');
        return false;
    }
    UICtrl.addTabItem({
        tabid: 'nonProdApplyExtended',
        text: "非产品/非半成品类物料主数据扩展申请",
        url: web_app.name + '/sapNonProdApply/forwardNonProdApplyDetail.job?bizId='+id+"&extend=1"
    });
}
// 发布数据
function publishDatas(message, id) {
    DataUtil.updateById({
        action : '/sapNonProdApply/publishDataToSap.ajax',
        gridManager : gridManager,
        param : {
            id : id
        },
        message : message,
        onSuccess : function() {
            reloadGrid();
        }
    });
}

//从EXCEL导入数据
function impExcelDataHandler(){
    ExcelImpManager.showImpDialog('导入', 'materialData',new Date().getTime(), function (){
        reloadGrid();
    });
}
//导出Excel
function exportExcelHandler() {
    var date = Public.formatDate(new Date(),`%Y%M%D`);
    UICtrl.gridExport(gridManager,{fileName:"物料主数据"+date});
}

// function next(){
//     UICtrl.addTabItem({
//         tabid: 'showNonProdApplyNext',
//         text: "非产品/非半成品类物料主数据维护申请详情",
//         url: web_app.name + '/sapNonProdApply/forwardNonProdApplyNext.do?isDetailPage=true'
//     });
// }