var gridManager = null;
$(document).ready(function () {
        initUI();
        initPurchaseListGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initPurchaseListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
    gridManager = UICtrl.grid('#grid', {
        columns : [
            {display: "库存盘点凭证", name: "iblnr", width: "80", align: "left", type: "string",},
            {display: "会计年度", name: "gjahr", width: "100", align: "left", type: "string"},
            {display: "行号", name: "zeili", width: "60", align: "left", type: "string"},
            {display: "物料编号", name: "matnr", width: "100", align: "left", type: "string",
                //去掉前导零
                render: function (item) {
                    return item.matnr.replace(/^0+/, "");
                }
            },
            {display: "物料描述", name: "maktx", width: "300", align: "left", type: "string"},
            {display: "工厂", name: "werks", width: "100", align: "left", type: "string",},
            {display: "工厂名称", name: "name1", width: "200", align: "left", type: "string",},
            {display: "存储地点", name: "lgort", width: "100", align: "left", type: "string"},
            {display: "存储地点名称", name: "lgobe", width: "100", align: "left", type: "string",},
            {display: "批次编号", name: "charg", width: "100", align: "left", type: "string",},
            {display: "盘点日期", name: "zldat", width: "100", align: "left", type: "string",},
            {display: "账面数量", name: "buchm", width: "100", align: "left", type: "money",},
            {display: "盘点数量", name: "erfmg", width: "100", align: "left", type: "money",},
            {display: "差额数量", name: "difmg", width: "100", minWidth: 60, type: "money", align: "center",},
            {display: "计量单位", name: "meins", width: "100", minWidth: 60, type: "string", align: "center",},
            {display: "计量单位描述", name: "msehl", width: "100", minWidth: 60, type: "string", align: "center",},
            {display: "盘点金额", name: "wrtzl", width: "100", minWidth: 60, type: "money", align: "center",},
            {display: "账面金额", name: "wrtbm", width: "100", align: "left", type: "money",},
            {display: "本币差额", name: "dmbtr", width: "100", align: "left", type: "money",},
            {display: "货币码", name: "waers", width: "100", align: "left", type: "string"},
            {display: "货币描述", name: "ktext", width: "100", minWidth: 60, type: "string", align: "center",},
            {display: "消息类型", name: "type", width: "100", minWidth: 60, type: "string", align: "center",},
            {display: "消息文本", name: "message", width: "100", minWidth: 60, type: "string", align: "center",}
            ],
            dataAction: 'server',
            url: web_app.name + '/inventoryRecord/slicedInventoryRecordImList.ajax?',
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 20,
            heightDiff: -4,
            sortName: 'fillinDate',
            sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.id);
            },
        }
    );
    UICtrl.setSearchAreaToggle(gridManager);
}


/**
 * 查看采购申请详情
 * @param id 采购申请id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(gridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewInventoryRecord' + id,
        text: '查看库存盘点',
        url: web_app.name + '/inventoryRecord/showInventoryRecordDetail.job?isReadOnly=true&bizId=' + id
    });
}

function reloadGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(gridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

