var gridManager = null, refreshFlag = false, _roleId = null, purchaseSelectedList = [];
$(document).ready(function () {
        initUI();
        initGrid();
        bindEvents();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
       // addHandler: addHandler
        addProduceHandler: {id: 'produceException', text: '添加', img: 'fa-music', className: 'btn-gray',
            click: function () {
                UICtrl.addTabItem({
                    tabid: 'addExceptionReportProduce',
                    text: '新增生产异常报告',
                    url: web_app.name + '/exceptionReport/addExceptionReportDetail.job?billType=produce'
                });
            }
        },
        exportExcelHandler: exportExcelHandler,
       /* addPurchaseHandler: {id: 'purchaseException', text: '添加采购异常单', img: 'fa-building-o', className: 'btn-gray',
            click: function () {
                UICtrl.addTabItem({
                    tabid: 'addExceptionReportPurchase',
                    text: '新增采购异常报告',
                    url: web_app.name + '/exceptionReport/addExceptionReportDetail.job?billType=purchase'
                });
            }
        },
        addSupplierHandler: {id: 'supplierException', text: '添加供应商异常单', img: 'fa-book', className: 'btn-gray',
            click: function () {
                UICtrl.addTabItem({
                    tabid: 'addExceptionReportSupplier',
                    text: '新增供应商异常报告',
                    url: web_app.name + '/exceptionReport/addExceptionReportDetail.job?billType=supplier'
                });
            }
        }*/
    });
    gridManager = UICtrl.grid('#maingrid', {
            columns: getColumns(),
            dataAction: 'server',
            url: web_app.name + '/exceptionReport/slicedExceptionReportList.ajax?',
            //parms: {requireItemId: $("#prepareItemId").val()},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 100,
            heightDiff: -4,
            sortName: 'fillinDate',
            sortOrder: 'desc',
            checkbox: false,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
        allowAdjustColWidth: true,
            onSuccess: function (data) {
                if (data.error) {
                    Public.tip(data.error);
                }
            }
            ,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.id);
            },
            onAfterShowData: function (currentData) {

            }
        }
    );
    UICtrl.setSearchAreaToggle(gridManager);
}

function getColumns(){
    var columns = [
        {display: "状态", name: "statusTextView", width: "60", align: "left", type: "string"}
        , {display: "id", name: "id", width: "100", align: "left", type: "string", hide: true}
        , {display: "报告编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "工厂", name: "werksName", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "异常类型", name: "exceptionTypeTextView", width: 80, minWidth: 60, type: "string", align: "center"}
        , {display: "紧急程度", name: "urgencyTextView", width: 80, minWidth: 60, type: "string", align: "center"}
        , {display: "原因分类", name: "exceptionReasonTypeTextView", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常问题类型", name: "reasonTypeDetailName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常问题类型代码", name: "reasonTypeDetail", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常问题一级分类", name: "reasonTypeName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "产品类别", name: "productTypeName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常日期", name: "exceptionDate", width: 100, minWidth: 60, type: "date", align: "center"}
        , {display: "客户是否需要改善报告", name: "needImproveReportTextView", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "客户是否需要保证书", name: "needGuaranteeTextView", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "处理方式", name: "dealWayTextView", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "呈报日期", name: "reportDate", width: 100, minWidth: 60, type: "date", align: "center"}
        , {display: "客户编号", name: "customerNo", width: 200, minWidth: 60, type: "date", align: "center"}
        , {display: "客户名称", name: "customerName", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "客户订单号", name: "customerOrderNo", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "生产单号", name: "produceNo", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "品牌名称", name: "brandName", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "问题发生次数", name: "problemTimes", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "赔付金额", name: "payMoney", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "损失金额", name: "loseMoney", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "异常陈诉", name: "exceptionState", width: 300, minWidth: 60, type: "string", align: "center"}
        , {display: "异常原因", name: "exceptionReason", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "改善措施", name: "dealMethod", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "处理部门", name: "dutyDeptName", width: 120, minWidth: 60, type: "string", align: "center"}
        , {display: "处理人", name: "checkOperatorName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "处理结果", name: "dealResult", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "单位主管", name: "manager", width: 120, minWidth: 60, type: "string", align: "center"}
        , {display: "副理", name: "deputyManager", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "经理", name: "generalManager", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "备注", name: "remark", width: 200, minWidth: 60, type: "date", align: "center"}
        , {display: "创建日期", name: "fillinDate", width: 150, minWidth: 60, type: "dateTime", align: "center"}
        , {display: "创建部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "center"}
        , {display: "创建人", name: "personMemberName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "产品编码", name: "productCode", width: 100, minWidth: 60, hide: true}
        , {display: "产品名称", name: "productName", width: 100, minWidth: 60, hide: true}
    ]
    return columns;
}

function bindEvents() {
    //产品类别
    $('#productTypeName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "MATKL"}
        },
        onChange: function (value, data) {
            $('#productType').val(data.MATKL);
            $('#productTypeName').val(data.WGBEZ);
        }
    });
}

/**
 * 查看品质异常报告详情
 * @param id 品质异常报告id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(gridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewExceptionReport' + id,
        text: '查看品质异常报告',
        url: web_app.name + '/exceptionReport/showExceptionReportDetail.job?isReadOnly=true&bizId=' + id
    });
}

//添加按钮
function addHandler() {
    UICtrl.showAjaxDialog({
        title: '新增',
        width: 400,
        url: web_app.name + '/exceptionReport/chooseExceptionDetail.load',
        ok: insertHandler
    });
}

function insertHandler() {
    var _self = this;
    var billType = $("#billType").val();
    var title="采购/外发";
    if (billType=="produce"){
        title="生产";
    }
    if (billType==""){
         Public.errorTip("请选择异常单类型！");
        return false;
    }
    UICtrl.addTabItem({
        tabid: 'addException'+billType,
        text: '新增异常单('+title+")",
        url: web_app.name + '/exceptionReport/addExceptionReportDetail.job?billType='+billType
    });
    _self.close();
}

function deleteHandler() {
    var rows = DataUtil.getObjectBagData("maingrid");
    if (!rows || rows.length < 1) {
        Public.tip('common.warning.nochoose');
        return;
    }
    var ids = [];
    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        if (row.status != 0) {
            Public.errorTip('只能删除草稿状态的数据!');
            return;
        }
        ids.push(row.id);
    }
    if (!ids) {
        return;
    }
    Public.ajax(web_app.name + '/exceptionReport/deleteExceptionReport.ajax',
        {ids: $.toJSON(ids)},
        function () {
            reloadGrid();
        });
}

function reloadGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(gridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

//导出Excel
function exportExcelHandler() {
    UICtrl.setGridColumns(gridManager,getExportColumns());
    var date = Public.formatDate(new Date(),`%Y%M%D%H%I%S`);
    UICtrl.gridExport(gridManager,{fileName:"异常报告"+date});
    UICtrl.setGridColumns(gridManager,getColumns());
}

function getExportColumns() {
    var columns = [
         {display: "报告编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "创建日期", name: "fillinDate", width: 150, minWidth: 60, type: "dateTime", align: "center"}
        , {display: "创建人", name: "personMemberName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "工厂", name: "werksName", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "异常类型", name: "exceptionTypeTextView", width: 80, minWidth: 60, type: "string", align: "center"}
        , {display: "紧急程度", name: "urgencyTextView", width: 80, minWidth: 60, type: "string", align: "center"}
        , {display: "原因分类", name: "exceptionReasonTypeTextView", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常问题类型", name: "reasonTypeDetailName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常问题类型代码", name: "reasonTypeDetail", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常问题一级分类", name: "reasonTypeName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "产品类别", name: "productTypeName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常日期", name: "exceptionDate", width: 100, minWidth: 60, type: "date", align: "center"}
        , {display: "客户是否需要改善报告", name: "needImproveReportTextView", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "客户是否需要保证书", name: "needGuaranteeTextView", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "处理方式", name: "dealWayTextView", width: 150, minWidth: 60, type: "string", align: "center"}
        , {display: "呈报日期", name: "reportDate", width: 100, minWidth: 60, type: "date", align: "center"}
        , {display: "客户编号", name: "customerNo", width: 200, minWidth: 60, type: "date", align: "center"}
        , {display: "客户名称", name: "customerName", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "客户订单号", name: "customerOrderNo", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "生产单号", name: "produceNo", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "品牌名称", name: "brandName", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "问题发生次数", name: "problemTimes", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "赔付金额", name: "payMoney", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "损失金额", name: "loseMoney", width: 180, minWidth: 60, type: "string", align: "center"}
        , {display: "异常陈诉", name: "exceptionState", width: 300, minWidth: 60, type: "string", align: "center"}
        , {display: "异常原因", name: "exceptionReason", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "改善措施", name: "dealMethod", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "处理部门", name: "dutyDeptName", width: 120, minWidth: 60, type: "string", align: "center"}
        , {display: "处理人", name: "checkOperatorName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "处理结果", name: "dealResult", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "单位主管", name: "manager", width: 120, minWidth: 60, type: "string", align: "center"}
        , {display: "副理", name: "deputyManager", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "经理", name: "generalManager", width: 200, minWidth: 60, type: "string", align: "center"}
        , {display: "备注", name: "remark", width: 200, minWidth: 60, type: "date", align: "center"}
        , {display: "产品编码", name: "productCode", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "产品名称", name: "productName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "单位", name: "unit", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "单位描述", name: "unitName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "币别", name: "currencyName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "单价", name: "price", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "数量", name: "number", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "金额", name: "money", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "民币金额", name: "rmbMoney", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "出货日期", name: "sendDate", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "异常数量", name: "exceptionNumber", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "汇率", name: "exchangeRate", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "运输费", name: "freight", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "返工费", name: "rework", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "停工待料费", name: "stopWaitMaterial", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "开机费", name: "startupFee", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "工号/客户编码", name: "personNo", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "姓名/客户名", name: "personName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "部门名称", name: "deptName", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "定责比例", name: "dutyRate", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "个人责任比例", name: "personDutyRate", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "责任金额", name: "dutyMoney", width: 100, minWidth: 60, type: "string", align: "center"}
        , {display: "备注", name: "dutyRemark", width: 100, minWidth: 60, type: "string", align: "center"}
    ]
    return columns;
}

