var tableArray = [
    {
        parms: {reimbursementBaseInfoId:getId()},
        node: "reimbursementApplierGrid",
        gridManager: null,
        data: null,
        columns: [
            {display: "", name: "reimbursementDetailId", width: 80, minwidth: 80, type: "string", align: "left", hide: true},
            {display: "", name: "reimbursementBaseInfoId", width: 80, minwidth: 80, type: "string", align: "left", hide: true},
            {display: "", name: "gjahr2", width: 80, minwidth: 80, type: "string", align: "left", hide: true},

            {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
            {
                display: "计划内外付款标识", name: "zepPlan", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "ZEP_PLAN"}
                        },
                        back: {
                            ZEP_PLAN: "zepPlan",
                            ZEP_PLANNAME: "zepPlanname"
                        }
                    },
                }
            },
            {
                display: "计划内外标识名称",
                name: "zepPlanname",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
            },
            {
                display: "BP标识", name: "zepBptype", width: 120, minwidth: 120, type: "string", align: "left", hide: true
            },
            {
                display: "BP标识描述", name: "zepBptypename", width: 120, minwidth: 120, type: "string", align: "left", hide: true
            },
            {
                display: "BP(合作伙伴)", name: "partner", width: 120, minwidth: 120, type: "string", align: "left", hide: true
            },
            {
                display: "BP账号名称", name: "koinh", width: 200, minwidth: 120, type: "string", align: "left", hide: true
            },
            {
                display: "BP银行账号", name: "bankn", width: 200, minwidth: 120, type: "string", align: "left", hide: true
            },
            {
                display: "BP联行号", name: "bankl", width: 120, minwidth: 120, type: "string", align: "left", hide: true
            },
            {
                display: "SWIFT/BIC", name: "swift", width: 120, minwidth: 120, type: "string", align: "left", hide: true
            },
            {
                display: "采购发票号", name: "belnr2", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "实体发票号", name: "zzinvcnr", width: 300, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "对账单号", name: "xblnr", width: 150, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "币别", name: "waers", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "汇率", name: "kursf", width: 120, minwidth: 120, type: "string", align: "left",
            },

            {
                display: "含税金额", name: "kzwi1", width: 120, minwidth: 120, type: "money", align: "left",
                editor: {
                    mask: 'nnnnnnnnn.nn',
                    type: 'text'
                }
            },
            {
                display: "含税金额（本位币）", name: "kzwi11", width: 120, minwidth: 120, type: "money", align: "left",
                render:function(item){
                    var money = 0;
                    if (item.waers === "CNY"){
                        money=item.kzwi1;
                    }else {
                        money=MathUtil.mul(item.kzwi1,item.kursf).toFixed(2);
                    }
                    return item.kzwi11 = money;
                }
            }
        ]
    },
    {
        parms: {},
        node: "financialAuditGrid",
        gridManager: null,
        data: null,
        columns: [
            {display: "", name: "rstgr", width: 80, minwidth: 80, type: "string", align: "left", hide: true},
            {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
            {
                display: "是否付款", name: "zepPay", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "ZEP_PAY"}
                        },
                        back: {
                            ZEP_PAY: "zepPay",
                        }
                    },
                }
            },
            {
                display: "原因代码", name: "rstgrName", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {
                                fieldName: "RSTGR",
                                filterValue:$("#bukrs").val()
                            }
                        },
                        back: {
                            RSTGR: "rstgr",
                            TXT40: "rstgrName",
                        }
                    },
                }
            },
            {
                display: "含税金额（审批）",
                name: "zepPtdamount1",
                width: 120,
                minwidth: 120,
                type: "money",
                align: "left",
                editor: {
                    mask: 'nnnnnnnnn.nn',
                    type: 'text'
                }
            },
            {
                display: "含税金额（审批-本位币）",
                name: "zepPtdamount",
                width: 120,
                minwidth: 120,
                type: "money",
                align: "left",
                editor: {
                    mask: 'nnnnnnnnn.nn',
                    type: 'text'
                }
            },
            {display: "", name: "zlsch", width: 80, minwidth: 80, type: "string", align: "left", hide: true},
            {
                display: "付款方式", name: "zlschTextView", width: 200, minwidth: 120, type: "string", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {name: 'zlsch'},
                    textField: 'zlschTextView',
                    valueField: 'zlsch',
                    required: false,
                    render: function (item) {
                        return item.zlschTextView;
                    }
                },
            },
            {
                display: "直联付款标识", name: "zepBank", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "ZEP_BANK"}
                        },
                        back: {
                            ZEP_BANK: "zepBank",
                        }
                    },
                }
            }
        ]
    },
    // {
    //     parms: {},
    //     node: "capitalPostGrid",
    //     gridManager: null,
    //     data: null,
    //     columns: [
    //         {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
    //         {
    //             display: "付款银行账号", name: "bankn1", width: 120, minwidth: 120, type: "string", align: "left",
    //             editor: {
    //                 required: false, type: "select",
    //                 data: {
    //                     type: 'system',
    //                     name: "getCompanyAndBankInfos",
    //                     getParam: function (item) {
    //                         return {
    //                             BUKRS: $("#bukrs").val()
    //                         }
    //                     },
    //                     back: {
    //                         BANKN1: "bankn1",
    //                         TEXT1: "zt012kText1",
    //                     }
    //                 },
    //             }
    //         },
    //         {
    //             display: "付款银行账号名称",
    //             name: "zt012kText1",
    //             width: 120,
    //             minwidth: 120,
    //             type: "string",
    //             align: "left",
    //             editor: {
    //
    //                 type: 'text'
    //             }
    //         },
    //         {
    //             display: "付款附言", name: "zepTxt1", width: 120, minwidth: 120, type: "string", align: "left",
    //             editor: {
    //
    //                 type: 'text'
    //             }
    //         },
    //     ]
    // }
     {
        parms: {},
        node: "financialAudit_sapReturnGrid",
        gridManager: null,
        data: null,
        columns: [
            {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
            {display: "记账凭证编号", name: "belnr", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "记账凭证财年", name: "gjahr", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "记账过账日期", name: "budat", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "记账凭证日期", name: "bldat", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "返回状态", name: "msgty", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "返回消息", name: "msgtx", width: 300, minwidth: 120, type: "string", align: "left"},
        ]
    }
    , {
        parms: {},
        node: "paymentAccomplish_sapReturnGrid",
        gridManager: null,
        data: null,
        columns: [
            {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
            {display: "付款凭证编号", name: "belnr1", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "付款凭证财年", name: "gjahr1", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "付款状态", name: "zpayStaus", width: 120, minwidth: 120, type: "string", align: "left"}
        ]
    }
];
var isAllData = true;
var zepPayFlag = false,changed = false;


//创建表格（参数、列、插入的节点、数据源）
function loadGrid(obj) {
    var toolbarOptions = null;
    var canEdit = false;//是否可编辑
    var canDelay = false;//是否加载。不加载是为了隐藏的表格如果是必填，提交会校验是否填写。
    var isApply = isApplyProcUnit();
    if (isApply){
        if (obj.node==="reimbursementApplierGrid"){
            canEdit = true;
        }else if (obj.node==="financialAuditGrid"
            //|| obj.node==="capitalPostGrid"
        ){
            //canDelay = true;
        }
    }
    var subProcUnitId = getSubProcUnitId();
    //财务审核
    if ("financeNode" === subProcUnitId){
        if (obj.node==="financialAuditGrid"){
            canEdit = true;
            var columns = obj.columns;
            columns.some(column => {
                if (//column.name == "rstgrName" ||
                    column.name == "zepPay"
                    || column.name == "zlschTextView"
                    //|| column.name == "zepBank"
                ){
                    column.editor.required = true;
                }
            })
            obj.columns = columns;
        }
        // else if (obj.node==="capitalPostGrid"){
        //     canDelay = true;
        // }
    }

    //资金岗
    // if ("fundNode" === subProcUnitId && obj.node==="capitalPostGrid"){
    //     canEdit = true;
    // }
    if(obj.node==="reimbursementApplierGrid" && isApply) {//只有第一个表格含工具栏
        toolbarOptions = UICtrl.getDefaultToolbarOptions({
            addHandler: function () {
                var bukrs = $("#bukrs").val();
                if (bukrs == null || bukrs == "") {
                    Public.tip("请先选择公司代码");
                    return;
                }
                var partner = $("#partner").val();
                if (partner == null || partner == "") {
                    Public.tip("请先选择BP(合作伙伴)");
                    return;
                }
                UICtrl.showAjaxDialog({
                    title: '选择发票',
                    height: 400,
                    width: 1600,
                    url: web_app.name + '/sapCostReimbursement/showAddPayApplyDetail.load',
                    param: {
                        bukrs: $("#bukrs").val(),
                        partner: $("#partner").val()
                    },
                    ok: function (d) {
                        var _self = this;
                        var rows = gridManager.getSelectedRows();
                        var _grid = UICtrl.getGridManager('#reimbursementApplierGrid');
                        var dates = _grid.currentData.Rows
                        for (var i = 0; i < rows.length; i++) {
                             var row = rows[i];
                            if (dates != null && dates.length > 0) {
                                for (let j = 0; j < dates.length; j++) {
                                    var data = dates[j];
                                    if (data.belnr2 == row.BELNR2 ) {
                                        Public.tip("采购发票号" + data.belnr2 +" 已选择，请取消勾选！");
                                        return false;
                                    }
                                }
                            }
                            tableArray.forEach((item) => {
                                UICtrl.addGridRow(item.gridManager,
                                    {
                                        zepItemno: getZepItemNo(),
                                        zepBptype:"K",
                                        zepBptypename:"供应商",
                                        zlsch:"T",
                                        zlschTextView:"T-电汇",
                                        belnr2: row.BELNR2,
                                        gjahr2: row.GJAHR,
                                        zzinvcnr: row.ZZINVCNR,
                                        zrsegitem: row.ZRSEG_ITEM,
                                        waers: row.WAERS,
                                        kursf: row.KURSF,
                                        kzwi1: row.KZWI1,
                                        kzwi11: row.KZWI11,
                                        xblnr: row.XBLNR,
                                        partner: $("#partner").val(),
                                        koinh: $("#koinh").val(),
                                        bankn: $("#bankn").val(),
                                        bankl: $("#bankl").val(),
                                        swift: $("#swift").val(),
                                    });
                            });
                        }
                        //totalGrid();
                        _self.close();
                    },
                })
            },
            deleteHandler: function () {
                // tableArray.forEach((item) => {
                //     item.gridManager.deleteSelectedRow();
                // });
                var _grid = UICtrl.getGridManager('#reimbursementApplierGrid');
                DataUtil.delSelectedRows({
                    action: 'sapCostReimbursement/deleteSapCostReimbursementDetails.ajax',
                    param: {},
                    gridManager: _grid,
                    idFieldName: 'reimbursementDetailId',
                    onSuccess: function () {
                        reloadGrid();
                        //totalGrid();
                    },
                });
                tableArray.forEach((item) => {
                    var data = item.gridManager.getSelectedRows();
                    $.each(data, function (i, o) {
                        item.gridManager.deleteRow(o);
                    });
                })
            },
            copyHandler: {
                id: 'copyHandler', text: '复制', img: 'fa-copy', click: function () {
                    tableArray.forEach((item) => {
                        //var row = DataUtil.getSelectedRow(item.gridManager);
                        var row = item.gridManager.getSelectedRow();
                        if (!row) {
                            Public.tip("请勾选一条数据");
                            return;
                        }
                        var newRow = JSON.parse(JSON.stringify(row));
                        newRow.zepItemno = getZepItemNo();
                        newRow.reimbursementDetailId = null;
                        newRow.zepPtdamount1 = null;
                        newRow.zepPtdamount = null;
                        UICtrl.addGridRow(item.gridManager, newRow);
                    });
                }
            }
        });
    }
    obj.gridManager = UICtrl.grid("#" + obj.node, {
        columns: obj.columns,
        dataAction: "local",
        data: obj.data,
        parms: obj.parms,
        pageSize: 20,
        toolbar: toolbarOptions,
        usePager: false,
        enabledEdit: canEdit,
        delayLoad: canDelay,
        // width: "100%",
        // height: 300,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        autoApplyNextEditor:false,
        //onAfterEdit: totalMoney,
        onBeforeCheckRow: function (checked, data) {
            //同时选定或取消所有表格中的对应行
            tableArray.forEach((item) => {
                let rows = item.gridManager.rows;
                let row = {};
                rows.forEach((temp) => {
                    if (temp.zepItemno === data.zepItemno) {
                        row = temp;
                    }
                })
                checked ? item.gridManager.select(row) : item.gridManager.unselect(row);
            })
            return false;//阻止默认事件、防止某个表格的对应行被多次选中
        },
        onBeforeCheckAllRow: function (a, b) {
            // console.log(b)
            // $(b).addClass("l-checked")

            // debugger
            //同时全选、同时取消全选
            // tableArray.forEach((item) => {
            //     let hrow=$(item.gridManager.element);//全选框
            //     console.log(hrow)
            //     console.log(item.gridManager.element)
            //
            //     let checked= !hrow.hasClass("l-checked");
            //     $(hrow).toggleClass("l-checked",checked);
            //     let rows = item.gridManager.selected;
            //     rows.forEach((row) => {
            //         checked?item.gridManager.select(row):item.gridManager.unselect(row);
            //     })
            // })
            return false;//阻止默认事件
        },
        onAfterEdit:function (item) {
            if(item.column.name == "waers"
                || item.column.name == "kursf"
                || item.column.name == "kzwi1"
                || item.column.name == "belnr2"
            ){
                totalGrid();
            }
            if (item.column.name == "zepPtdamount1"){
                var value = item.value;
                var zepItemno = item.record.zepItemno;
                var _grid = UICtrl.getGridManager('#reimbursementApplierGrid');
                var _secondGrid = UICtrl.getGridManager('#financialAuditGrid');
                if (_grid != null){
                    var datas = _grid.currentData.Rows;
                    if (datas.length > 0){
                        $.each(datas, function (i, data) {
                            if (data.zepItemno == zepItemno) {
                                if (MathUtil.compare(value,data.kzwi1) > 0){
                                    Public.tip("含税金额（审批）不能大于含税金额")
                                    $.each(_secondGrid.currentData.Rows, function (i, row) {
                                        if (data.zepItemno == row.zepItemno){
                                            _secondGrid.updateRow(row,{
                                                zepPtdamount1:data.kzwi1,
                                                zepPtdamount:MathUtil.mul(data.kzwi1,data.kursf)
                                            })
                                        }
                                    })
                                }else {
                                    $.each(_secondGrid.currentData.Rows, function (i, row) {
                                        if (data.zepItemno == row.zepItemno){
                                            _secondGrid.updateRow(row,{
                                                zepPtdamount:MathUtil.mul(row.zepPtdamount1,data.kursf)
                                            })
                                        }
                                    })
                                }
                            }
                        });
                        totalFinancialAuditGrid(_secondGrid.currentData.Rows);
                    }
                }
            }
            if(item.column.name == "zepPtdamount"){
                var _secondGrid = UICtrl.getGridManager('#financialAuditGrid');
                if (_secondGrid != null){
                    var secondRows = _secondGrid.currentData.Rows;
                    totalFinancialAuditGrid(secondRows);
                }
            }
            //是否付款选择“N”，“原因代码”和“银企直连标志”非必填
            if (item.column.name == "zepPay" && obj.node == "financialAuditGrid"){
                if (item.value == "Y"){
                    zepPayFlag = true;
                }
                if (item.value == "N"){
                    zepPayFlag = false;
                }
                var columns = obj.columns;
                columns.some(column => {
                    if (column.name == "rstgrName" ||
                        column.name == "zepBank" ){
                        column.editor.required = zepPayFlag;
                    }
                })
                obj.gridManager.set('columns', columns);
                //UICtrl.setGridColumns(obj.gridManager,columns);
            }
            return item;
        },
        onAfterShowData:function (){
            if ("financeNode" === subProcUnitId){
                initFinancialAuditGridData();
            }
            if ("fundNode" === subProcUnitId){
                //如果财务审核是无需付款，付款银行账号非必填
                var _secondGrid = UICtrl.getGridManager('#financialAuditGrid');
                if (_secondGrid!=null){
                    var checked7 = false;
                    $.each(_secondGrid.currentData.Rows, function (i, row) {
                        if (row.zepPay == "Y"){
                            checked7 = true
                        }
                    });
                    if (checked7){
                        UICtrl.setElRequiredFlag("#bankn1",true)
                    }
                }
            }
            totalGrid();
        }
    });
    UICtrl.setSearchAreaToggle(obj.gridManager);

}

function totalMoney(data) {
    // alert(data.column.name);
    // debugger
    // data=data.record;
    var totals = 0;
    if (data.column.name == "kzwi1") {
        var rows = tableArray[0].gridManager.rows;
        if (rows) {
            for (var i in rows) {
                var list = rows[i];
                if (list.kzwi1) { // alert(list.kzwi1);
                    totals = accAdd(totals, list.kzwi1);
                }
            }
        }
        $("#zepFtamount1").val(totals);
    }
}

$(document).ready(function () {
    initialize();
    bindQueryEvent();
    nodeController();
});


function initialize() {
    //获取数据源初始化表格
    Public.ajax(web_app.name + '/sapCostReimbursement/slicedSapCostReimbursementDetailList.ajax', {reimbursementBaseInfoId: getId()}, function (data) {
        //根据定义列拆除实体对象，封装成每个table对应的数据集
        tableArray.forEach(obj => {
            obj.data = {
                Rows: data.Rows.map(item => {
                    let row = {};
                    obj.columns.forEach(col => {
                        if (item.hasOwnProperty(col.name)) {
                            row[col.name] = item[col.name];
                        }
                    });
                    return row;
                })
            };
        });
        useArrayTable(loadGrid);
    })
    // $("#zepFtypename").val("付款申请流程");
    // $("#zepFtype").val("C");
    // $("#butxt").val("广州市宝绅科技应用有限公司");
    // $("#bukrs").val("1000");

}

function bindQueryEvent() {
    $('#bukrs').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "BUKRS"}
        },
        onChange: function (value, data) {
            $('#bukrs').val(data.BUKRS);
            $('#butxt').val(data.BUTXT);
        }
    });

    $('#bankn1').searchbox({
        type: "system", name: "getCompanyAndBankInfos",
        getParam: function (item) {
            return {BUKRS: $("#bukrs").val()}
        },
        onChange: function (value, data) {
            $('#bankn1').val(data.BANKN1);
            $('#zt012kText1').val(data.TEXT1);
        }
    });

    $('#partner').searchbox({
        type: "system", name: "getCusAndSuppliers",
        getParam: function (item) {
            return {
                ZEP_BPTYPE: "K",
                BUKRS:$("#bukrs").val()
            }
        },
        onChange: function (value, data) {
            var partner = $("#partner").val();

            $('#partner').val(data.PARTNER);
            $('#koinh').val(data.NAME_ORG1);
            $("#text1").val(data.TEXT1);

            if (Public.isBlank(value) || partner !== data.PARTNER) {
                $('#bankn').val('');
                $('#bankl').val('');
                $('#swift').val('');
            }
        }
    });

    $('#bankn').searchbox({
        type: "system", name: "getCusAndBanks",
        getParam: function (item) {
            return {
                ZEP_BPTYPE: "K",
                PARTNER: $("#partner").val()
            }
        },
        onChange: function (value, data) {
            $('#bankn').val(data.BANKN);
            $('#bankl').val(data.BANKL);
            $('#swift').val(data.SWIFT);
        }
    });
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function getExtendedData(processAction) {
    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT || "2" == getHandleResult()) {
        isAllData = false
        //不验证
        $('#submitForm').attr('check', false);
    }
    let resultArray = useArrayTable(getTableDataAll);

    //根据zepItemno将各列表属性合并为一个完整实体
    const result = resultArray[0].map((obj1) => {
        const mergedObj = {...obj1};
        for (let i = 1; i < resultArray.length; i++) {
            const currentArr = resultArray[i];
            const currentObj = currentArr.find((obj) => obj.zepItemno === obj1.zepItemno);
            if (currentObj) {
                Object.assign(mergedObj, currentObj);
            }
        }
        return mergedObj;
    });
    var _reimbursementGrid = UICtrl.getGridManager('#reimbursementApplierGrid');
    var reimbursementDatas = DataUtil.getGridData({
        gridManager: _reimbursementGrid,
        isAllData: isAllData,
        onCheck: function () {
            return true;
        }
    });
    if (!reimbursementDatas) {
        return false;
    }
    var nos = [];
    for (var i = 0; i < reimbursementDatas.length; i++) {
        var item = reimbursementDatas[i];
        if (nos.length>0 && nos.includes(item.zepItemno) ) {
            Public.tip("EP流程子序号不能重复")
            return false;
        }else {
            nos.push(item.zepItemno);
        }
    }
    var subProcUnitId = getSubProcUnitId();
    //如果没有收到SAP消息回执，不能提交归档
    if ("file" === subProcUnitId){
        var _financialGrid = UICtrl.getGridManager('#financialAuditGrid');
        var financialDatas = DataUtil.getGridData({
            gridManager: _financialGrid,
            isAllData: isAllData,
            onCheck: function () {
                return true;
            }
        });
        if (!financialDatas) {
            return false;
        }
        var checked7 = false
        var num = 0;
        $.each(financialDatas, function (i, o) {
            if (o.zepPay == "Y"){
                checked7 = true
            }
        });
        var _grid = UICtrl.getGridManager('#paymentAccomplish_sapReturnGrid');
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: isAllData,
            onCheck: function () {
                return true;
            }
        });
        if (!datas) {
            return false;
        }
        var checked6 = false
        if (checked7){
            $.each(datas, function (i, o) {
                if (Public.isBlank(o.belnr1) || Public.isBlank(o.gjahr1)){
                    checked6 = true;
                }
            })
        }
        if (checked6){
            Public.tip("请收到'付款完成、sap回执'消息后才归档");
            return false;
        }
    }
    let extendedData = {};
    extendedData.CRDetail = Public.encodeJSONURI(result);
    return extendedData;

}

//提交前校验
function checkConstraints() {
    //原因代码、是否付款、直联付款标识必输，且如果为多行的话，这三个字段的值必须相同，不相同报错提示，不允许提交
    var subProcUnitId = getSubProcUnitId();
    //财务审核
    if ("financeNode" === subProcUnitId){
        var _grid = UICtrl.getGridManager('#financialAuditGrid');
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: isAllData,
            onCheck: function () {
                return true;
            }
        });
        if (!datas) {
            return false;
        }
        var checked1 = false
        var checked2 = false
        var checked3 = false
        $.each(datas, function (i, o) {
            if (o.rstgrName != datas[0].rstgrName ){
                checked1 = true
            }
            if (o.zepPay != datas[0].zepPay ){
                checked2 = true
            }
            if (o.zepBank != datas[0].zepBank ){
                checked3 = true
            }
        });
        if (checked1) {
            Public.tip("原因代码不一致")
            return false
        }
        if (checked2) {
            Public.tip("是否付款不一致")
            return false
        }
        if (checked3) {
            Public.tip("直联付款标识不一致")
            return false
        }
    }

    return true;
}

function getTableDataAll(obj) {
    let result = DataUtil.getGridData({
        gridManager: obj.gridManager,
        isAllData: isAllData
    });
    return result;
}

//调用数组
function useArrayTable(func, ...data) {
    const results = tableArray.map((item) => {
        return func(item, ...data);
    });
    return results;
}

//获取最新子序号（维护实体的标识）
function getZepItemNo() {
    let result = getTableDataAll(tableArray[tableArray.length - 1]);
    let zepItemNo = "001";
    if (result.length > 0) {
        //获取上一个节点的子序值
        let wornNo = parseInt(result[result.length - 1]["zepItemno"], 10);
        zepItemNo = ("00" + (wornNo + 1)).slice(-3);
    }
    return zepItemNo;
}
//UICtrl中校验是否允许编辑
function businessJudgmentUnit() {
    var isApply = isApplyProcUnit();
    if (isApply) {
        $("#approvalMoney").hide();
        $("#financialAudit").hide();
        $("#financialAudit_sapReturn").hide();
        $("#capitalPost").hide();
        $("#paymentAccomplish_sapReturn").hide();
        return true;
    }else {
        UICtrl.setDisable($("#submitForm"));
    }
    //资金岗
    if ("fundNode" === getSubProcUnitId()){
        UICtrl.enable("#bankn1");
        UICtrl.enable("#zepTxt1");
    }
    return true;
}


function nodeController(){
    var subProcUnitId = getSubProcUnitId();
    //财务审核
    if ("financeNode" === subProcUnitId){
        $("#financialAudit_sapReturn").hide();
        $("#capitalPost").hide();
        $("#paymentAccomplish_sapReturn").hide();
    }

    //资金岗
    if ("fundNode" === subProcUnitId){
        $("#financialAudit_sapReturn").hide();
        $("#paymentAccomplish_sapReturn").hide();
    }
}

function totalGrid(money) {
    var _grid = UICtrl.getGridManager('#reimbursementApplierGrid');
    if (_grid != null){
        //var data = _grid.currentData.Rows,
        var data = _grid.rows,
        zepFtamount1 = 0,//申请总金额
        zepFtamount = 0;//申请总金额（本位币）
        var _kzwi1 = 0;
        var _kzwi11 = 0;
        if (data.length > 0){
            $.each(data, function (i, o) {
                _kzwi1 = o['kzwi1'] + '';
                _kzwi11 = o['kzwi11'] + '';
                zepFtamount1 = MathUtil.add(zepFtamount1, _kzwi1);
                zepFtamount = MathUtil.add(zepFtamount, _kzwi11);
            });
        }
        $('#zepFtamount1').val(zepFtamount1);
        $('#zepFtamount').val(zepFtamount);
    }
}

function initFinancialAuditGridData(){
    var _grid = UICtrl.getGridManager('#reimbursementApplierGrid');
    var _secondGrid = UICtrl.getGridManager('#financialAuditGrid');
    if (_grid != null && _secondGrid != null){
        var datas = _grid.currentData.Rows;
        if (datas.length > 0 && _secondGrid.currentData != null){
            var secondRows = _secondGrid.currentData.Rows;
            $.each(datas, function (i, data) {
                $.each(secondRows, function (i, row) {
                    if (data.zepItemno === row.zepItemno && (row.zepPtdamount1===0 || Public.isBlank(row.zepPtdamount1))){
                        _secondGrid.updateRow(row,{
                            zepPtdamount1:data.kzwi1,
                            zepPtdamount:data.kzwi11
                        })
                    }
                });
            });
            totalFinancialAuditGrid(secondRows);
        }
    }
}

function totalFinancialAuditGrid(data){
    var zepPtamount = 0,//审批总金额（本位币）
        zepPtamount1 = 0;//审批总金额
    $.each(data, function (i, o) {
        var _zepPtdamount = o['zepPtdamount'] + '';
        var _zepPtdamount1 = o['zepPtdamount1'] + '';
        zepPtamount = MathUtil.add(zepPtamount, _zepPtdamount);
        zepPtamount1 = MathUtil.add(zepPtamount1, _zepPtdamount1);
        $('#zepPtamount').val(zepPtamount);
        $('#zepPtamount1').val(zepPtamount1);
    });
}

function reloadGrid(){
    //获取数据源初始化表格
    Public.ajax(web_app.name + '/sapCostReimbursement/slicedSapCostReimbursementDetailList.ajax', {reimbursementBaseInfoId: getId()}, function (data) {
        //根据定义列拆除实体对象，封装成每个table对应的数据集
        tableArray.forEach(obj => {
            obj.data = {
                Rows: data.Rows.map(item => {
                    let row = {};
                    obj.columns.forEach(col => {
                        if (item.hasOwnProperty(col.name)) {
                            row[col.name] = item[col.name];
                        }
                    });
                    return row;
                })
            };
            var gridManager = UICtrl.getGridManager("#"+obj.node);
            gridManager.setData(obj.data);
            Public.successTip("数据操作成功")
        });
    })
}