<%@ page language="java" contentType="text/html; charset=utf-8" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,combox,commonTree,date,attachment"/>
    <x:script src='/biz/topsun/sap/costReimbursement/costReimbursement.js'/>
</head>
<body>

<div class="container-fluid" style="padding: 10px;">
    <x:billTitle title="费用报销申请" needStatus="false" needPerson="true"/>
    <form class="hg-form" method="post" action="" id="submitForm">
        <x:hidden name="id"/>
        <x:hidden name="billCode"/>
        <x:hidden name="fillinDate" type="datetime"/>
        <x:hidden name="fullId"/>
        <x:hidden name="organId"/>
        <x:hidden name="organName"/>
        <x:hidden name="deptId"/>
        <x:hidden name="deptName"/>
        <x:hidden name="positionId"/>
        <x:hidden name="positionName"/>
        <x:hidden name="personMemberId"/>
        <x:hidden name="personMemberName"/>
        <div class="hg-form-cols">
            <div class="hg-form-row">
                <x:inputC name="zepNo" required="false" readonly="true" label="EP流程单号" labelCol="2" maxLength="64" fieldCol="2"/>
                <x:inputC name="zepFcrdate" required="false" readonly="true" wrapper="date" label="付款申请创建日期" labelCol="2" fieldCol="2"/>
                <x:inputC name="zepFtype" required="false" readonly="true" label="EP付款申请类别" labelCol="2" maxLength="64" fieldCol="2"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="zepFtypename" required="false" readonly="true" label="EP付款申请类别名称" labelCol="2" maxLength="64" fieldCol="2"/>
                <x:inputC name="bukrs" required="true" label="公司代码" labelCol="2" fieldCol="2" wrapper="select"/>
                <x:inputC name="butxt" required="false" readonly="true" label="公司代码名称" labelCol="2" fieldCol="2"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="zepDepart" required="false" readonly="true" label="EP部门代码" labelCol="2" fieldCol="2"/>
                <x:inputC name="zepDepartname" required="false" readonly="true" label="EP部门名称" labelCol="2" fieldCol="2"/>
                <x:inputC name="zepAppli" required="false" readonly="true" label="EP流程申请人代码" labelCol="2" fieldCol="2"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="zepAppliname" required="false" readonly="true" label="EP流程申请人" labelCol="2" fieldCol="2"/>
                <x:inputC name="zepTxt" required="true" label="付款申请内容" labelCol="2" fieldCol="6"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="employeeLoanBillCode" required="false" label="员工借款编号" labelCol="2" fieldCol="2" wrapper="select"/>
                <x:inputC name="employeeLoanText" required="false" label="员工借款内容" labelCol="2" fieldCol="6" readonly="true"/>
            </div>
            <div id="capitalPost">
                <div class="hg-form-row">
                    <x:inputC name="bankn1" required="false" label="付款银行账号" labelCol="2" fieldCol="2" wrapper="select"/>
                    <x:inputC name="zt012kText1" required="false" readonly="true" label="付款银行账号名称" labelCol="2" fieldCol="2"/>
                    <x:inputC name="zepTxt1" required="false" label="付款附言" labelCol="2" fieldCol="2"/>
                </div>
            </div>
            <div class="hg-form-row">
                <x:inputC name="zepFtamount" required="false" readonly="true" label="申请总金额（本位币）" labelCol="2" fieldCol="2" mask="positiveMoney"/>
                <x:inputC name="zepFttax" required="false" readonly="true" label="申请总税额（本位币）" labelCol="2" fieldCol="2" mask="positiveMoney"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="zepFttax1" required="false" readonly="true" label="申请总税额" labelCol="2" fieldCol="2" mask="positiveMoney"/>
                <x:inputC name="zepFtamount1" required="false" readonly="true" label="申请总金额" labelCol="2" fieldCol="2" mask="positiveMoney"/>
            </div>

            <div id="approvalMoney">
                <div class="hg-form-row">
                    <x:inputC name="zepPtamount" required="false" readonly="true" label="审批总金额（本位币）" labelCol="2" fieldCol="2" mask="positiveMoney"/>
                    <x:inputC name="zepPttax" required="false" readonly="true" label=" 审批总税额（本位币）" labelCol="2" fieldCol="2" mask="positiveMoney"/>
                </div>
                <div class="hg-form-row">
                    <x:inputC name="zepPttax1" required="false" readonly="true" label="审批总税额" labelCol="2" fieldCol="2" mask="positiveMoney"/>
                    <x:inputC name="zepPtamount1" required="false" readonly="true" label="审批总金额" labelCol="2" fieldCol="2" mask="positiveMoney"/>
                </div>
            </div>
            <div class="hg-form-row">
                <x:textareaC name="payReason" required="false" label="付款事由" labelCol="2" fieldCol="10" rows="3"/>
            </div>
        </div>
            <div style="padding-top: 15px;">
                <x:fileList bizCode="costReimbursement" bizId="id" id="fileList" title="相关资料" />
            </div>
        <div class="blank_div clearfix"></div>
        <x:title title="报销人填写" name="group"/>
        <div id="reimbursementApplierGrid" style="margin: 2px;">
        </div>
        <div class="blank_div clearfix"></div>
        <div id="financialAudit">
            <x:title title="财务审核填写" name="group"/>
            <div id="financialAuditGrid" style="margin: 2px;">
            </div>
        </div>
        <div class="blank_div clearfix"></div>
        <div id="financialAudit_sapReturn">
            <x:title title="财务已审核、sap回执" name="group"/>
            <div id="financialAudit_sapReturnGrid" style="margin: 2px;">
            </div>
        </div>
        <div class="blank_div clearfix"></div>
<%--        <div id="capitalPost">--%>
<%--            <x:title title="资金岗填写" name="group"/>--%>
<%--            <div id="capitalPostGrid" style="margin: 2px;">--%>
<%--            </div>--%>
<%--        </div>--%>
        <div class="blank_div clearfix"></div>
        <div id="paymentAccomplish_sapReturn">
            <x:title title="付款完成、sap回执" name="group"/>
            <div id="paymentAccomplish_sapReturnGrid" style="margin: 2px;">
            </div>
        </div>
</div>
</form>
</body>
</html>
