var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){
    //if (typeof(getSubProcUnitId) =='function'&&"10" === getSubProcUnitId()) {
    var mainFileTable = $('#componentSupplyInfoList').fileList();
    mainFileTable.find('table').css({
        borderTopWidth : 0
    });
    $('#componentSupplyInfoList').fileList({
        bizId : $("#attbizId").val()
    });
    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent(){
    $("#departName").orgTree({
        filter: "ogn,dpt", excludePos: 0, param: {orgKindId: "ogn,dpt"},
        back: {
            text: "#departName",
            value : '#depart'
        },
        //manageType: 'taskQuery',
        onChange:function(value,data){
            $('#depart').val(data.id);
        }
    });

    $("#applyPersonName").orgTree({
        filter: "psm", excludePos: 0, param: {orgKindId: "ogn,dpt,pos,psm"},
        back: {
            text: "#applyPersonName",
            value : '#applyPerson'
        },
        //manageType: 'taskQuery',
        onChange:function(value,data){
            $('#applyPerson').val(data.id);
        }
    });

    //供应商
    $('#suppliersName').searchbox({
        type: "system", name: "selectSuppliersDatas",
        getParam: function (item) {
            return {
                ///  fieldName: "sapMaterialSelect",
                //filterValue: $('#werks').val()
            }
        },
        onChange: function (value, data) {
            $('#suppliers').val(data.partner);
            $('#suppliersName').val(data.nameOrg1);
        }
    });
    //工厂
    $('#werksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            $('#werks').val(data.WERKS);
            $('#werksName').val(data.NAME1);
        }
    });
}

function loadGrid() {
    var toolbarOptions =null;
    //if ($("#statusId").val()==0){
       toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            UICtrl.addGridRow(gridManager);
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#maingrid');
            DataUtil.delSelectedRows({
                action: 'componentSupplyItem/deleteComponentSupplyItems.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        }
       // copyHandler: copyHandler
       // impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},

     });
  //  }
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "产品物料", name: "productMaterial", width: "160", align: "left", type: "string",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "sapMaterialSelect",
                        getParam: function (item) {
                            return {
                               // filterValue:$('#suppliers').val(),
                                wlfl1:"ZZCP",
                                wlfl2:"ZBCP"

                            }
                        },
                        back: {
                            MATNR: "productMaterial",
                            MAKTX: "productMaterialName"
                        }
                    },
                }
            },
            {display: "产品物料名称", name: "productMaterialName", width: "200", align: "left", type: "string"},
            {display: "供给物料", name: "supplyMaterial", width: "160", align: "left", type: "string",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "sapMaterialSelect",
                        getParam: function (item) {
                            return {
                               // filterValue:$('#suppliers').val(),
                                noWlfl1:"ZZCP",
                                noWlfl2:"ZBCP"
                            }
                        },
                        back: {
                            MATNR: "supplyMaterial",
                            MAKTX: "supplyMaterialName"
                        }
                    },
                }
            },
            {display: "供给物料名称", name: "supplyMaterialName", width: "200", align: "left", type: "string"},

            { display: "补发数量", name: "quantity", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {  type: "text",mask: 'nnnnnn.nn',required: true }
            },
            { display: "提货方式", name: "deliveryMethodTextView", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {name: 'deliveryMethod'},
                    textField: 'deliveryMethodTextView',
                    valueField: 'deliveryMethod',
                    required: true,
                    render: function (item) {
                        return item.deliveryMethodTextView;
                    }
                }
            },
            {
                display: "说明", name: "remark", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {required: false, type: "text"}
            }
        ],
        dataAction: "server",
        url: web_app.name + '/componentSupplyItem/queryComponentSupplyItems.ajax',
        pageSize: 10,
        usePager: true,
        parms:{componentSupplyId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "80%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.componentSupplyId = id;
    $('#componentSupplyInfoList').fileList({
        bizId : id
    });
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}


function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });

        if (!datas) {
            return false;
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

