var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

var defaultcols = [
    {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
    {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
    {
        display: "订单类型", name: "orderTypeName", width: 150, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "订单原因（业务交易原因）", name: "augru", width: 200, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "订单编号", name: "vbeln", width: 100, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "生产工单", name: "workorderCode", width: 100, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "跟单员", name: "merchandiserName", width: 100, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "订单总金额", name: "amount", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "客户采购单号", name: "bstnk", width: 100, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "销售凭证项目", name: "posnr", width: 60, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "物料编号", name: "matnr", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "物料描述", name: "maktx", width: 300, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "订单数量", name: "kwmeng", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "销售单位", name: "vrkme", width: 60, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "价格", name: "vaKbetr", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "工厂", name: "werks", width: 200, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "指令号", name: "zinstnum", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "型体号", name: "zmold", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "配色号", name: "zmapcolor", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "品牌", name: "mvgr1", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {
        display: "物料组", name: "matkl", width: 140, minWidth: 60, type: "string", align: "left",
    },
    {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
    {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
    {display: "联系电话长号", name: "telPhoneLong", width: 200, minWidth: 60, type: "string", align: "left"},
    {display: "联系电话短号", name: "telPhoneShort", width: 200, minWidth: 60, type: "string", align: "left"},
    {display: "售达方", name: "kunnr", width: 200, minWidth: 60, type: "string", align: "left"},
    {display: "退货原因", name: "returnReason", width: 200, minWidth: 60, type: "string", align: "left"},
    {display: "责任部门", name: "dutyDept", width: 100, minWidth: 60, type: "string", align: "left"},
    {display: "责任人", name: "dutyBy", width: 100, minWidth: 60, type: "string", align: "left"},
    {display: "后续处理意见", name: "returnOpinion", width: 200, minWidth: 60, type: "string", align: "left"},
    {display: "其他备注", name: "returnRemark", width: 200, minWidth: 60, type: "string", align: "left"},
    {display: "退货地址", name: "returnAddress", width: 200, minWidth: 60, type: "string", align: "left"},
    {display: "审批状态", name: "statusTextView", width: 100, minWidth: 60, type: "string", align: "left"},
    {display: "状态码", name: "code", width: 100, minWidth: 60, type: "string", align: "left"},
    {display: "消息", name: "msg", width: 200, minWidth: 60, type: "string", align: "left"},
]

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        //addHandler: addHandler,
        printHandler: {
            id: 'print', text: '打印', img:'fa-clipboard', click: function(){
                printHandler();
            }
        },
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: defaultcols,
        _tableKey: 'epSaleOrderList',
        _local: true,
        dataAction: "server",
        url: web_app.name + '/epSaleOrder/slicedEpSaleOrderList.ajax',
        pageSize: 20,
        usePager: true,
        sortName: 'fillinDate',
        sortOrder: 'desc',
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}


function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'epSaleOrder',
        text: "新增销售订单",
        url: web_app.name + '/epSaleOrder/forwardEpSaleOrderDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'epSaleOrder'+id,
        text: "查看销售订单",
        url: web_app.name + '/epSaleOrder/showEpSaleOrderDetail.job?bizId='+id+"&isReadOnly=true"
    });
}

function printHandler(){
    var row = DataUtil.getUpdateRow(gridManager);
    if (!row) {
        return;
    }
    if (row.status != 3){
        Public.tip("请审批完成再打印!");
        return;
    }
    if (row.orderType != "ZHR" && row.orderType != "ZRE1"){
        Public.tip("只能打印退货退款和换货退回订单!");
        return;
    }
    var url='/epSaleOrder/print.load';
    Public.openPostWindow(web_app.name+url,{id :row.id});
}
