<%@ page language="java" contentType="text/html; charset=utf-8" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,combox,commonTree,date"/>
    <x:script src='/biz/topsun/ep/epSaleOrder/epSaleOrderDetail.js'/>
</head>
<body>
<x:billTitle title="销售订单" needStatus="false" needPerson="true"/>
<form class="hg-form" method="post" action="" id="submitForm">
    <x:hidden name="id"/>
    <x:hidden name="billCode"/>
    <x:hidden name="fillinDate" type="datetime"/>
    <x:hidden name="fullId"/>
    <x:hidden name="organId"/>
    <x:hidden name="organName"/>
    <x:hidden name="deptId"/>
    <x:hidden name="deptName"/>
    <x:hidden name="positionId"/>
    <x:hidden name="positionName"/>
    <x:hidden name="personMemberId"/>
    <x:hidden name="personMemberName"/>
    <x:hidden name="orderType"/>
    <x:hidden name="orderTypeName"/>
    <x:hidden name="statusId"/>
    <x:hidden name="merchandiser"/>
    <div class="hg-form-cols">
        <div class="hg-form-row">
            <c:if test="${orderType=='ZRE1' || orderType=='ZHR'}">
                <x:inputC name="contact" required="true" label="客户联系人" labelCol="1" maxLength="64" fieldCol="2"/>
                <x:inputC name="telPhoneLong" required="true" label="客户联系电话" labelCol="1" maxLength="64" fieldCol="2"/>
            </c:if>
            <c:if test="${orderType!='ZRE1' && orderType!='ZHR'}">
                <x:inputC name="telPhoneLong" required="false" label="联系电话长号" labelCol="1" maxLength="64" fieldCol="2"/>
            </c:if>
            <x:inputC name="telPhoneShort" required="false" label="联系电话短号" labelCol="1" fieldCol="2"/>
            <x:inputC name="kunnr" required="true" label="售达方" labelCol="1" fieldCol="2"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="dutyDept" required="false" label="责任部门" labelCol="1" fieldCol="2"/>
            <x:inputC name="dutyBy" required="false" label="责任人" labelCol="1" fieldCol="2"/>
        </div>
        <div class="hg-form-row">
            <x:textareaC name="returnReason" required="false" label="退货原因" labelCol="1" rows="2" fieldCol="5"/>
            <x:textareaC name="returnAddress" required="false" label="退货地址" labelCol="1" rows="2" fieldCol="5"/>
        </div>
        <div class="hg-form-row">
            <x:textareaC name="returnOpinion" required="false" label="后续处理意见" labelCol="1" rows="2" fieldCol="5"/>
            <x:textareaC name="returnRemark" required="false" label="其他备注" labelCol="1" rows="2" fieldCol="5"/>
        </div>
    </div>
    <div class="blank_div clearfix"></div>
    <div id="maingrid" style="margin: 2px;">
    </div>
</form>
</body>
</html>
