var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){
    UICtrl.setDisable($("#submitForm"));
    // var orderTypeName = $("#orderTypeName").val();
    // $('#jobBizBillBody .subject').html(orderTypeName);
    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent(){

}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {
                display: "销售单号", name: "vbeln", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "项次", name: "posnr", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "跟单员", name: "merchandiserName", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "物料编号", name: "matnr", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "物料描述", name: "maktx", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "数量", name: "kwmeng", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "单位", name: "vrkme", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "单价", name: "price", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "总价", name: "amount", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "生产单号", name: "produceCode", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "工序", name: "process", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            }
        ],
        dataAction: "server",
        _tableKey: 'epSaleOrderCancelItem',
        _local: true,
        url: web_app.name + '/epSaleOrderCancelItem/queryEpSaleOrderCancelItems.ajax',
        pageSize: 10,
        usePager: true,
        parms:{epSaleOrderCancelId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: false,
        width: "100%",
        height: "60%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.epSaleOrderCancelId = id;
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}

function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}
