package com.huigou.topsun.sap.costCenter.domain.query;

import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/14
 * description:
 */
@Data
public class CostCenterQueryRequest extends QueryAbstractRequest {
    /**
     * id
     */
    private String id;
    /**
     * 成本中心编码
     */
    private String KOSTL;

    /**
     * 有效期自 默认当年1月1日
     */
    private Date DATAB;

    /**
     * 有效截至日 默认9999.12.31
     */
    private Date DATBI;

    /**
     * 名称
     */
    private String KTEXT;

    /**
     * 描述
     */
    private String LTEXT;

    /**
     * 负责人
     */
    private String VERAK;

    /**
     * 成本中心类型
     * 管理类	L
     * 销售类	V
     * 研发类	E
     * 间接生产类	G
     * 直接生产类	F
     */
    private String KOSAR;

    /**
     * 利润中心
     * 10001000 广州宝绅科技利润中心
     * 10001001 广州宝绅RFID利润中心
     */
    private String PRCTR;
}
