package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 产品打样排版参数配置
 * @TableName product_published_conf
 */
@Table(name="product_published_conf")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductPublishedConf implements Serializable {
    /**
     * 排版参数配置ID
     */
    @Id
    @Column(name = "product_published_conf_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productPublishedConfId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productId;

    /**
     * 模数
     */
    @Column(name = "modulus")
    private Integer modulus;

    /**
     * 行数
     */
    @Column(name = "row_num")
    private Integer rowNum;

    /**
     * 列数
     */
    @Column(name = "column_num")
    private Integer columnNum;

    /**
     * 搭版数
     */
    @Column(name = "contact_num")
    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */
    @Column(name = "row_double_blade")
    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */
    @Column(name = "column_double_blade")
    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */
    @Column(name = "dispatch_multiple")
    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */
    @Column(name = "sheet_length")
    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    @Column(name = "sheet_width")
    private Double sheetWidth;

    /**
     * 产品印张设置(product_sheet_conf)
     */
    @Column(name = "product_sheet_conf")
    private String productSheetConf;

    public BigDecimal getProductPublishedConfId() {
        return productPublishedConfId;
    }

    public void setProductPublishedConfId(String productPublishedConfId) {
        this.productPublishedConfId = (productPublishedConfId != null) ? new BigDecimal(productPublishedConfId) : null;
    }

    public BigDecimal getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = (productId != null) ? new BigDecimal(productId) : null;
    }

    public Integer getModulus() {
        return modulus;
    }

    public void setModulus(Integer modulus) {
        this.modulus = modulus;
    }

    public Integer getRowNum() {
        return rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public Integer getColumnNum() {
        return columnNum;
    }

    public void setColumnNum(Integer columnNum) {
        this.columnNum = columnNum;
    }

    public Integer getContactNum() {
        return contactNum;
    }

    public void setContactNum(Integer contactNum) {
        this.contactNum = contactNum;
    }

    public Double getRowDoubleBlade() {
        return rowDoubleBlade;
    }

    public void setRowDoubleBlade(Double rowDoubleBlade) {
        this.rowDoubleBlade = rowDoubleBlade;
    }

    public Double getColumnDoubleBlade() {
        return columnDoubleBlade;
    }

    public void setColumnDoubleBlade(Double columnDoubleBlade) {
        this.columnDoubleBlade = columnDoubleBlade;
    }

    public Integer getDispatchMultiple() {
        return dispatchMultiple;
    }

    public void setDispatchMultiple(Integer dispatchMultiple) {
        this.dispatchMultiple = dispatchMultiple;
    }

    public Double getSheetLength() {
        return sheetLength;
    }

    public void setSheetLength(Double sheetLength) {
        this.sheetLength = sheetLength;
    }

    public Double getSheetWidth() {
        return sheetWidth;
    }

    public void setSheetWidth(Double sheetWidth) {
        this.sheetWidth = sheetWidth;
    }

    public String getProductSheetConf() {
        return productSheetConf;
    }

    public void setProductSheetConf(String productSheetConf) {
        this.productSheetConf = productSheetConf;
    }
}