package com.huigou.topsun.customer.domain.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.customer.domain.Customer;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CustomerVo implements Serializable {
    /**
     * 客户id
     */
    private String customerId;

    /**
     * 客户编码
     */
    private String customerCode;

    /**
     * 客户全称
     */
    private String customerName;

    /**
     * 客户简称
     */
    private String customerShortName;

    /**
     * 客户工作时间
     */
    private Date customerWorkTime;

    /**
     * 客户英文名称
     */
    private String customerEnName;

    /**
     * 客户英文名称简称
     */
    private String customerEnShortName;

    /**
     * 省份编码
     */
    private String provinceCode;

    /**
     * 省份信息
     */
    private String provinceInfo;

    /**
     * 客户等级
     */
    private String customerLevel;

    /**
     * 工厂代号
     */
    private String customerFactoryCode;

    /**
     * 地址
     */
    private String customerAddress;

    /**
     * 所属集团
     */
    private String customerGroup;

    /**
     * 邮编
     */
    private String customerZipCode;

    /**
     *
     */
    private String customerBankId;

    /**
     * 开户银行
     */
    private String customerBankDeposit;

    /**
     * 银行账号
     */
    private String customerAccountNo;

    /**
     * 户名
     */
    private String customerAccountName;

    /**
     * 公司法人
     */
    private String customerCorporation;

    /**
     * 工商注册号
     */
    private String businessRegistrationNumber;

    /**
     * 国税注册号
     */
    private String nationalTaxRegistrationNumber;

    public String getCustomerId() {
        return customerId;
    }

    public static CustomerVo getCustomerVo(CustomerVo customerVo){
        return JSON.parseObject(JSON.toJSONString(customerVo), CustomerVo.class);
    }

    public static Customer getCustomer(Customer customer){
        return JSON.parseObject(JSON.toJSONString(customer),Customer.class);
    }
}
