package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 催货款通知邮箱
 * @TableName customer_debt_contact
 */
@Table(name="customer_debt_contact")
@Entity
@Data
public class CustomerDebtContact implements Serializable {
    /**
     * 催货款通知邮箱id
     */
    @Id
    @Column(name = "customer_debt_contact_id")
    private String customerDebtContactId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 邮箱地址
     */
    @Column(name = "customer_eamil")
    private String customerEamil;

    /**
     * 联系人
     */
    @Column(name = "customer_contact")
    private String customerContact;

    /**
     * 是否开启邮件发送
     */
    @Column(name = "send_eamil")
    private String sendEamil;

    /**
     * 邮箱类型（customerEmailType）-（宝绅邮箱、客户邮箱）
     */
    @Column(name = "customer_email_type")
    private String customerEmailType;

    /**
     * 创建人id
     */
    @Column(name = "created_by_id")
    private String createdById;

    /**
     * 创建人名称
     */
    @Column(name = "created_by_name")
    private String createdByName;

    /**
     * 创建日期
     */
    @Column(name = "created_date")
    private Date createdDate;

    private static final long serialVersionUID = 1L;
}