var processGridManager = null;
$(document).ready(function () {
    loadProcessListGrid();
    bindQueryEvent();
    bindEvent();
});

function loadProcessListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            UICtrl.addGridRow(processGridManager,{ sortNum: processGridManager.getData().length + 1 });
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#processListGrid');
            DataUtil.delSelectedRows({
                action: 'technologyProcess/deleteTechnologyProcess.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'technologyProcessId',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        }
    });
    processGridManager = UICtrl.grid("#processListGrid", {
        columns: [
            {display: "序号", name: "sortNum", width: 80, minWidth: 60, type: "string", align: "left",
                editor: { type: 'spinner', min: 1, max: 100, mask: 'nnn'}
            },
            {
                display: "工序名称", name: "processName", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "processNameGroup",
                        back: {
                            processId: "processId",
                            processName: "processName",
                            processType: "processType",
                            processTypeTextView: "processTypeTextView",
                            workHours: "workHours",
                            processContent: "processContent",
                            processRemark: "processRemark",
                        }
                    },
                }
            },
            {
                display: "工序类别",
                name: "processTypeTextView",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left",
                /*editor : {
                    type : 'combobox',
                    data : $("#processType").combox('getJSONData'),
                    required : true,
                    valueField : 'processType'
                }*/
            },
            {
                display: "工时", name: "workHours", width: 120, minWidth: 60, type: "number", align: "left",
                /*editor: {
                    required: true,
                    type: 'text',
                    mask: 'positiveMoney'
                }*/
            },
            {
                display: "工序内容", name: "processContent", width: 180, minWidth: 60, type: "string", align: "left",
                /*editor: {
                    required: true,
                    type: 'text'
                }*/
            },
            {
                display: "工序说明", name: "processRemark", width: 180, minWidth: 60, type: "string", align: "left",
                /*editor: {
                    required: true,
                    type: 'text'
                }*/
            },
        ],
        dataAction: "server",
        url: web_app.name + '/technologyProcess/slicedTechnologyProcessList.ajax',
        parms: {technologyId: getId},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "98%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(processGridManager);
}

function bindQueryEvent() {
    $('#productName').searchbox({
        type: "product", name: "productCode",
        onChange: function (value, data) {
            $('#productId').val(data.productId);
            $('#productName').val(data.productName);
        }
    });
}

function bindEvent() {
    $("#save").click(function () {
        saveData("save");
    })
    $("#submit").click(function () {
        saveData("submit");
    })

    $("#close").click(function () {//关闭
        closeDispatchTabItem();
    })
}

function getTechnologyDetail(processAction) {
    //采购订单保存时数据不进行必填验证，提交时数据才进行必填验证
    var op = {};
    var check = true;
    var processList = [];
    if (processAction == "save") {
        check = false;
    }
    op = {check: check};
    var technology = $('#submitForm').formToJSON(op);
    if (!technology) {
        return false;
    }
    processList = DataUtil.getGridData({gridManager: processGridManager, isAllData: true, onCheck: check})
    if (!processList) {
        return false;
    }
    technology.processList = $.toJSON(processList);
    return technology;
}

function saveData(action) {
    var technologyDetail = getTechnologyDetail("submit");
    if (!technologyDetail) {
        return;
    }
    Public.ajax(web_app.name + '/technology/saveTechnology.ajax?code=' + action,technologyDetail,
        function (data) {
            setId(data.technologyId);
            Public.successTip("数据保存成功");
            processGridManager.setParm('technologyId', data.technologyId);
            processGridManager.loadData();
        }
    );
}

function closeDispatchTabItem() {
    UICtrl.closeCurrentTab();
}

function setId(value) {
    $('#technologyId').val(value);
}

function getId() {
    return $("#technologyId").val();
}

