<%@ page language="java" contentType="text/html; charset=utf-8" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,combox,commonTree"/>
    <x:script src='/biz/topsun/technology/processDetail.js'/>
</head>
<body>
    <x:billTitle title="工序详情" needStatus="false" needPerson="true"/>
    <div class="blank_div clearfix"></div>
    <button class="btn btn-default" type="button" id="close" style="left: 200px;float:right;bottom: 10px;">关闭</button>
    <button class="btn btn-warning" type="button" id="submit" style="left: 200px;float:right;bottom: 10px;">提交</button>
    <button class="btn btn-success" type="button" id="save" style="left: 200px;float:right;bottom: 10px;">保存</button>
    <form class="hg-form" method="post" action="" id="submitForm">
        <x:hidden name="processId"/>
        <div class="hg-form-row">
            <x:inputC name="processName" required="true" label="工序名称" labelCol="2" maxLength="64" fieldCol="4"/>
            <x:selectC name="processType" required="true" label="工序类别" labelCol="2" dictionary="processType" fieldCol="4"/>
            <x:inputC name="processContent" required="true" label="工序内容" labelCol="2" maxLength="64" fieldCol="4"/>
            <x:inputC name="workHours" required="true" label="工时" labelCol="2" mask="nnnn.nn" dataOptions="min:0" maxLength="32" fieldCol="4"/>
            <x:inputC name="processRemark" required="false" label="工序说明" labelCol="2" maxLength="32" fieldCol="10"/>
        </div>
        <div class="blank_div clearfix"></div>
        <x:title title="工序资源" name="group" hideTable="#info"/>
        <div id="resourceGrid" style="margin: 2px;"></div>
        <div class="blank_div clearfix"></div>
        <x:title title="工序物料" name="group" hideTable="#info"/>
        <div id="processMaterialGrid" style="margin: 2px;"></div>
    </form>
</body>
</html>
