var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadWorkInstructionApplyListGrid();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadWorkInstructionApplyListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        updateHandler: function(){
            updateHandler();
        },
        deleteHandler: deleteHandler
    });
    gridManager = UICtrl.grid("#workInstructionApplyTableGrid", {
        columns: [
            {display: "规格书编号", name: "specificationNo", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "换算值", name: "matrixingValue", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "尺码组", name: "sizeGroup", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "是否禁用", name: "isDisableTextView", width: 140, minWidth: 60, type: "string", align: "left"}
         ],
        dataAction: "server",
        url: web_app.name + '/workInstructionApply/slicedQueryWorkInstructionApplyList.ajax',
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.workInstructionApplyId);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}


function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

// function addHandler() {
//     UICtrl.showAjaxDialog({
//         url: web_app.name + '/proofingMake/forwardSaveProofingMake.load',
//         title: "新增打样制造单",
//         width: 1000,
//         ok: function (div) {
//             var _self = this;
//             $('#submitForm', div).ajaxSubmit({
//                 url: web_app.name + '/proofingMake/saveProofingMake.ajax',
//                 success: function () {
//                     _self.close();
//                     reloadGrid();
//                 }
//             });
//         }
//     });
// }

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'updateWorkInstructionApply'+row.workInstructionApplyId,
        text: "修改作业申请书",
        url: web_app.name + '/workInstructionApply/forwardDetailsWorkInstructionApply.do?id='+row.workInstructionApplyId
    });
}


//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'workInstructionApply/deleteWorkInstructionApply.ajax',
        gridManager: gridManager, idFieldName: 'workInstructionApplyId',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function doView(workInstructionApplyId) {
    UICtrl.addTabItem({
        tabid: 'workInstructionApply'+workInstructionApplyId,
        text: "作业申请书详情",
        url: web_app.name + '/workInstructionApply/forwardDetailsWorkInstructionApply.job?id='+workInstructionApplyId
    });
}