<%@ page contentType="text/html; charset=utf-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%
    String serverHost = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    String basePath = serverHost + request.getContextPath();
    request.setAttribute("basePath", basePath);
%>
<!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=5,IE=9" ><![endif]-->
<!DOCTYPE html>
<html>
<head>
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <x:base include="flexField,combox,grid,dialog,layout,tree"/>
    <link rel="stylesheet" type="text/css" href="${basePath}/system/configtool/editor/styles/grapheditor.css">
    <x:i18n name="messages"/>
    <x:script src="/lib/underscore-min.js" />
    <script type="text/javascript">
        var basePath = '${basePath}';
        var mxBasePath = basePath + '/system/configtool/editor/mxClient';
        var RESOURCES_PATH = basePath + '/system/configtool/editor/resources';
        var STYLE_PATH = basePath + '/system/configtool/editor/styles';
        var STENCIL_PATH = basePath + '/system/configtool/editor/stencils';
        var SAVE_URL = basePath + '/procDefinition/saveModel.ajax';
        var OPEN_URL = basePath + '/procDefinition/queryModel.ajax';
        var EXPORT_URL = basePath + '/procDefinition/export.ajax';
        var OPEN_FORM = basePath + '/system/configtool/editor/open.html';
        // Parses URL parameters. Supported parameters are:
        // - lang=xy: Specifies the language of the user interface.
        // - touch=1: Enables a touch-style user interface.
        // - storage=local: Enables HTML5 local storage.
        // - chrome=0: Chromeless mode.
        var urlParams = (function (url) {
            var result = new Object();
            var idx = url.lastIndexOf('?');

            if (idx > 0) {
                var params = url.substring(idx + 1).split('&');

                for (var i = 0; i < params.length; i++) {
                    idx = params[i].indexOf('=');

                    if (idx > 0) {
                        result[params[i].substring(0, idx)] = params[i].substring(idx + 1);
                    }
                }
            }

            return result;
        })(window.location.href);

        // Default resources are included in grapheditor resources
        mxLoadResources = false;
    </script>
    <script type="text/javascript" src="${basePath}/lib/underscore-min.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/stencilset.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Init.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/deflate/pako.min.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/deflate/base64.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/jscolor/jscolor.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/sanitizer/sanitizer.min.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/mxClient/js/mxClient.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/EditorUi.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Editor.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Sidebar.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Graph.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Format.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Shapes.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Actions.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Menus.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Toolbar.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/js/Dialogs.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/chart.js"></script>
    <script type="text/javascript" src="${basePath}/system/configtool/editor/modeler.js"></script>
</head>
<body class="geEditor">
<div id="process-info">
    <x:hidden name="id"/>
    <x:hidden name="code"/>
    <x:hidden name="name"/>
</div>
</body>
</html>
