package com.huigou.topsun.technology.domain.model;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 工序
 * @TableName process
 */
@Table(name="process")
@Data
@Entity
public class Process implements Serializable {
    /**
     * 工序ID
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "process_id")
    private String processId;

    /**
     * 工序名称
     */
    @Column(name = "process_name")
    private String processName;

    /**
     * 工序说明
     */
    @Column(name = "process_remark")
    private String processRemark;

    /**
     * 工时
     */
    @Column(name = "work_hours")
    private Double workHours;

    /**
     * 工序类别(process_type)
     */
    @Column(name = "process_type")
    private String processType;

    /**
     * 工序内容
     */
    @Column(name = "process_content")
    private String processContent;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        Process other = (Process) that;
        return (this.getProcessId() == null ? other.getProcessId() == null : this.getProcessId().equals(other.getProcessId()))
            && (this.getProcessName() == null ? other.getProcessName() == null : this.getProcessName().equals(other.getProcessName()))
            && (this.getProcessRemark() == null ? other.getProcessRemark() == null : this.getProcessRemark().equals(other.getProcessRemark()))
            && (this.getWorkHours() == null ? other.getWorkHours() == null : this.getWorkHours().equals(other.getWorkHours()))
            && (this.getProcessType() == null ? other.getProcessType() == null : this.getProcessType().equals(other.getProcessType()))
            && (this.getProcessContent() == null ? other.getProcessContent() == null : this.getProcessContent().equals(other.getProcessContent()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProcessId() == null) ? 0 : getProcessId().hashCode());
        result = prime * result + ((getProcessName() == null) ? 0 : getProcessName().hashCode());
        result = prime * result + ((getProcessRemark() == null) ? 0 : getProcessRemark().hashCode());
        result = prime * result + ((getWorkHours() == null) ? 0 : getWorkHours().hashCode());
        result = prime * result + ((getProcessType() == null) ? 0 : getProcessType().hashCode());
        result = prime * result + ((getProcessContent() == null) ? 0 : getProcessContent().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", processId=").append(processId);
        sb.append(", processName=").append(processName);
        sb.append(", processRemark=").append(processRemark);
        sb.append(", workHours=").append(workHours);
        sb.append(", processType=").append(processType);
        sb.append(", processContent=").append(processContent);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}