package com.huigou.topsun.sap.statsIndicators.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * @TableName sap_stats_indicators_result
 */
@Table(name="sap_stats_indicators_result")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class SapStatsIndicatorsResult implements Serializable {
    /**
     * 回执信息id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "stats_indicators_result_id")
    private String statsIndicatorsResultId;

    /**
     * 主表id
     */
    @Column(name = "stats_indicators_id")
    private String statsIndicatorsId;

    /**
     * 消息类型
     */
    @Column(name = "TYPE")
    private String type;

    /**
     * 消息类
     */
    @Column(name = "ID")
    private String id;

    /**
     * 消息编号
     */
    @Column(name = "NUMBER")
    private Integer number;

    /**
     * 消息文本
     */
    @Column(name = "MESSAGE")
    private String message;

    /**
     * 应用程序日志：日志编号
     */
    @Column(name = "LOG_NO")
    private String logNo;

    /**
     * 应用程序日志：内部消息序列号
     */
    @Column(name = "LOG_MSG_NO")
    private Integer logMsgNo;

    /**
     * 消息变量
     */
    @Column(name = "MESSAGE_V1")
    private String messageV1;

    /**
     * 消息变量
     */
    @Column(name = "MESSAGE_V2")
    private String messageV2;

    /**
     * 消息变量
     */
    @Column(name = "MESSAGE_V3")
    private String messageV3;

    /**
     * 消息变量
     */
    @Column(name = "MESSAGE_V4")
    private String messageV4;

    /**
     * 参数名称
     */
    @Column(name = "PARAMETER")
    private String parameter;

    /**
     * 参数中的行
     */
    @Column(name = "`ROW`")
    private Integer row;

    /**
     * 参数中的字段
     */
    @Column(name = "FIELD")
    private String field;

    /**
     * 引发消息的逻辑系统
     */
    @Column(name = "`SYSTEM`")
    private String system;

    /**
     * 凭证编号
     */
    @Column(name = "BELNR")
    private String belnr;

    private static final long serialVersionUID = 1L;
}