package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品风险描述
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_risk_description")
public class ProductRiskDescription implements Serializable {

	/**
	 * 产品风险描述id
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_risk_description_id", nullable = false)
	private BigDecimal productRiskDescriptionId;

	/**
	 * 产品id
	 */
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_id", nullable = true)
	private BigDecimal productId;

	/**
	 * 序号
	 */
	@Column(name = "sequence", nullable = true)
	private Integer sequence;

	/**
	 * 内容
	 */
	@Column(name = "product_risk_description", nullable = true, length = 255)
	private String productRiskDescription;

	/**
	 * 等级
	 */
	@Column(name = "product_risk_level", nullable = true, length = 32)
	private String productRiskLevel;
	
	public BigDecimal getProductRiskDescriptionId() {
		return this.productRiskDescriptionId;
	}
	
	public void setProductRiskDescriptionId (String  productRiskDescriptionId) {
		this.productRiskDescriptionId = (productRiskDescriptionId == null) || productRiskDescriptionId.isEmpty() ? null : new BigDecimal(productRiskDescriptionId);
	}
	
	public BigDecimal getProductId() {
		return this.productId;
	}
	
	public void setProductId (String  productId) {
		this.productId = (productId == null) || productId.isEmpty() ? null : new BigDecimal(productId);
	}
	
	public Integer getSequence() {
		return this.sequence;
	}
	
	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}
	
	public String getProductRiskDescription() {
		return this.productRiskDescription;
	}
	
	public void setProductRiskDescription(String productRiskDescription) {
		this.productRiskDescription = productRiskDescription;
	}
	
	public String getProductRiskLevel() {
		return this.productRiskLevel;
	}
	
	public void setProductRiskLevel(String productRiskLevel) {
		this.productRiskLevel = productRiskLevel;
	}
}
