package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product")
public class Product implements Serializable {

	@OneToOne(mappedBy = "product")
	private ProductDetail productDetail;

	/**
	 * 产品ID
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_id", nullable = false)
	private BigDecimal productId;

	/**
	 * 产品名称
	 */
	@Column(name = "product_name", nullable = true, length = 128)
	private String productName;

	/**
	 * 产品类别
	 */
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_category_id", nullable = true)
	private BigDecimal productCategoryId;

	/**
	 * 产品状态(码表status)
	 */
	@Column(name = "product_status", nullable = true, length = 32)
	private String productStatus;

	/**
	 * 产品计量单位
	 */
	@Column(name = "product_unit", nullable = true, length = 32)
	private String productUnit;

	/**
	 * 样品编号
	 */
	@Column(name = "product_sample_code", nullable = true, length = 32)
	private String productSampleCode;

	/**
	 * 品牌名称
	 */
	@Column(name = "brand_name", nullable = true, length = 128)
	private String brandName;

	/**
	 * 产品类型(prodcut_type)
	 */
	@Column(name = "product_type", nullable = true, length = 32)
	private String productType;

	/**
	 * 产品编码
	 */
	@Column(name = "product_code", nullable = true, length = 255)
	private String productCode;

	/**
	 * 尺码组id
	 */
	@Column(name = "product_size_group_id", nullable = true, length = 32)
	private String productSizeGroupId;

	/**
	 * 是否为唯一码产品
	 */
	@Column(name = "is_only_code", nullable = true, length = 1)
	private String isOnlyCode;

	/**
	 * 是否不考虑形体配色
	 */
	@Column(name = "is_body_color", nullable = true, length = 1)
	private String isBodyColor;

	/**
	 * 是否禁用
	 */
	@Column(name = "is_disable", nullable = true, length = 1)
	private String isDisable;

	/**
	 * 是否建立bom表
	 */
	@Column(name = "is_build_bom", nullable = true, length = 10)
	private String isBuildBom;

	/**
	 * 确认日期
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@Column(name = "confirm_date", nullable = true)
	private java.util.Date confirmDate;

	/**
	 * 确认人
	 */
	@Column(name = "comfirm_person", nullable = true, length = 32)
	private String comfirmPerson;

	/**
	 * 是否免检
	 */
	@Column(name = "is_free_inspection", nullable = true, length = 10)
	private String isFreeInspection;

	/**
	 * 不要质量loss%
	 */
	@Column(name = "is_no_quality_loss", nullable = true, length = 255)
	private String isNoQualityLoss;

	/**
	 * 样品单号
	 */
	@Column(name = "sample_order_no", nullable = true, length = 255)
	private String sampleOrderNo;

	/**
	 * 库存编码
	 */
	@Column(name = "stock_no", nullable = true, length = 255)
	private String stockNo;

	/**
	 * 库存名称
	 */
	@Column(name = "stock_name", nullable = true, length = 255)
	private String stockName;

	/**
	 * 存档编号
	 */
	@Column(name = "file_no", nullable = true, length = 255)
	private String fileNo;

	public ProductDetail getProductDetail() {
		return productDetail;
	}

	public void setProductDetail(ProductDetail productDetail) {
		this.productDetail = productDetail;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		Product product = (Product) o;
		return new EqualsBuilder().append(productId, product.productId).append(productName, product.productName).append(productCategoryId, product.productCategoryId).append(productStatus, product.productStatus).append(productUnit, product.productUnit).append(productSampleCode, product.productSampleCode).append(brandName, product.brandName).append(productType, product.productType).append(productCode, product.productCode).append(productSizeGroupId, product.productSizeGroupId).append(isOnlyCode, product.isOnlyCode).append(isBodyColor, product.isBodyColor).append(isDisable, product.isDisable).append(isBuildBom, product.isBuildBom).append(confirmDate, product.confirmDate).append(comfirmPerson, product.comfirmPerson).append(isFreeInspection, product.isFreeInspection).append(isNoQualityLoss, product.isNoQualityLoss).append(sampleOrderNo, product.sampleOrderNo).append(stockNo, product.stockNo).append(stockName, product.stockName).append(fileNo, product.fileNo).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(productId).append(productName).append(productCategoryId).append(productStatus).append(productUnit).append(productSampleCode).append(brandName).append(productType).append(productCode).append(productSizeGroupId).append(isOnlyCode).append(isBodyColor).append(isDisable).append(isBuildBom).append(confirmDate).append(comfirmPerson).append(isFreeInspection).append(isNoQualityLoss).append(sampleOrderNo).append(stockNo).append(stockName).append(fileNo).toHashCode();
	}

	public BigDecimal getProductId() {
		return this.productId;
	}
	
	public void setProductId (String  productId) {
		this.productId = (productId == null) || productId.isEmpty() ? null : new BigDecimal(productId);
	}
	
	public String getProductName() {
		return this.productName;
	}
	
	public void setProductName(String productName) {
		this.productName = productName;
	}
	
	public BigDecimal getProductCategoryId() {
		return this.productCategoryId;
	}
	
	public void setProductCategoryId (String  productCategoryId) {
		this.productCategoryId = (productCategoryId == null) || productCategoryId.isEmpty() ? null : new BigDecimal(productCategoryId);
	}
	
	public String getProductStatus() {
		return this.productStatus;
	}
	
	public void setProductStatus(String productStatus) {
		this.productStatus = productStatus;
	}
	
	public String getProductUnit() {
		return this.productUnit;
	}
	
	public void setProductUnit(String productUnit) {
		this.productUnit = productUnit;
	}
	
	public String getProductSampleCode() {
		return this.productSampleCode;
	}
	
	public void setProductSampleCode(String productSampleCode) {
		this.productSampleCode = productSampleCode;
	}
	
	public String getBrandName() {
		return this.brandName;
	}
	
	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}
	
	public String getProductType() {
		return this.productType;
	}
	
	public void setProductType(String productType) {
		this.productType = productType;
	}
	
	public String getProductCode() {
		return this.productCode;
	}
	
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}
	
	public String getProductSizeGroupId() {
		return this.productSizeGroupId;
	}
	
	public void setProductSizeGroupId(String productSizeGroupId) {
		this.productSizeGroupId = productSizeGroupId;
	}
	
	public String getIsOnlyCode() {
		return this.isOnlyCode;
	}
	
	public void setIsOnlyCode(String isOnlyCode) {
		this.isOnlyCode = isOnlyCode;
	}
	
	public String getIsBodyColor() {
		return this.isBodyColor;
	}
	
	public void setIsBodyColor(String isBodyColor) {
		this.isBodyColor = isBodyColor;
	}
	
	public String getIsDisable() {
		return this.isDisable;
	}
	
	public void setIsDisable(String isDisable) {
		this.isDisable = isDisable;
	}
	
	public String getIsBuildBom() {
		return this.isBuildBom;
	}
	
	public void setIsBuildBom(String isBuildBom) {
		this.isBuildBom = isBuildBom;
	}
	
	public java.util.Date getConfirmDate() {
		return this.confirmDate;
	}
	
	public void setConfirmDate(java.util.Date confirmDate) {
		this.confirmDate = confirmDate;
	}
	
	public String getComfirmPerson() {
		return this.comfirmPerson;
	}
	
	public void setComfirmPerson(String comfirmPerson) {
		this.comfirmPerson = comfirmPerson;
	}
	
	public String getIsFreeInspection() {
		return this.isFreeInspection;
	}
	
	public void setIsFreeInspection(String isFreeInspection) {
		this.isFreeInspection = isFreeInspection;
	}
	
	public String getIsNoQualityLoss() {
		return this.isNoQualityLoss;
	}
	
	public void setIsNoQualityLoss(String isNoQualityLoss) {
		this.isNoQualityLoss = isNoQualityLoss;
	}
	
	public String getSampleOrderNo() {
		return this.sampleOrderNo;
	}
	
	public void setSampleOrderNo(String sampleOrderNo) {
		this.sampleOrderNo = sampleOrderNo;
	}
	
	public String getStockNo() {
		return this.stockNo;
	}
	
	public void setStockNo(String stockNo) {
		this.stockNo = stockNo;
	}
	
	public String getStockName() {
		return this.stockName;
	}
	
	public void setStockName(String stockName) {
		this.stockName = stockName;
	}
	
	public String getFileNo() {
		return this.fileNo;
	}
	
	public void setFileNo(String fileNo) {
		this.fileNo = fileNo;
	}
}
