package com.huigou.topsun.product.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.cache.DictUtil;

import com.huigou.topsun.product.application.ProductApplication;
import com.huigou.topsun.product.application.ProductProcessApplication;
import com.huigou.topsun.product.domain.Product;
import com.huigou.topsun.product.domain.ProductProcess;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ProductController
 *
 * @author qinzhenguan
 * @createDate 2023/11/27 11:19
 **/
@Controller
@ControllerMapping("/product")
public class ProductController extends CommonController {

    @Autowired
    private ProductApplication productService;
    @Autowired
    private ProductProcessApplication processService;

    @Autowired
    private ObjectMapper objectMapper;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/product/";
    }

    /**
     * description 
     * @author qinzhenguan
     * @createDate 2023/11/27 11:49
     * @return null
     */
    public String findProduct() {//需要特定类型返回值
        ArrayList<Map<String,Object>> productPage = productService.findProductPage(0, 30);
        HashMap<Object, Object> map = new HashMap<>(3);
        map.put("Rows",productPage);
        return toResult(map);
    }

    public String forwardProduct() {
        return forward("product");
    }

    public String forwardProductDetail() {
        ObjectMapper objectMapper = new ObjectMapper();
        SDO sdo = this.getSDO();
        String str = sdo.getString("data");
        HashMap<String, Object> param;
        try {
            param = objectMapper.readValue(str, new TypeReference<HashMap<String, Object>>() {});
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return forward("productDetail", param);
    }

    public String loadProductDetail() {
        SDO sdo = this.getSDO();
        Product product ;
        try {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            product = objectMapper.readValue(sdo.getString("data") + "", Product.class);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);

        }
        Map<String, Object> resultMap = new HashMap<>();
        if(product.getProductId() != null) {
            resultMap = productService.queryDetailAll(product);
        }
        return toResult(resultMap);
    }

    public String saveOrUpdataOnAllDetail() throws JsonProcessingException {
        SDO sdo = this.getSDO();
        HashMap<String, Object> newData;
        try {
            newData = objectMapper.readValue(sdo.getString("data"), new TypeReference<HashMap<String, Object>>() {});
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        HashMap<String,Object> resultMap = productService.saveOrUpdataOnAllDetail(newData);
        return success(resultMap);
    }

    public String queryProcessbyTechnologyId() {
        SDO sdo = this.getSDO();
        BigDecimal technologyId = new BigDecimal(sdo.getString("productTechnologyId"));
        List<ProductProcess> list = processService.queryProcessbyTechnologyId(technologyId);

        return success(list);
    }

    @SkipAuth
    public String queryProductList() {
        HashMap<String, Object> aa = productService.queryProductList();
        String json = "";
        try {
            json = objectMapper.writeValueAsString(aa);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return success(aa);
    }

}

//// 通过此方法可以查看系统配置的 字典 的数据结构
//        DictUtil.getDictionaryList("technologyType");
//                Map<String, Object> map4 = new HashMap<>(10);
//        map4.put("六六六", "666");
//        map4.put("七七七", "777");
//        map4.put("八八八", "888");