package com.huigou.topsun.common;

import com.huigou.context.MessageSourceContext;
import com.huigou.util.StringUtil;

import java.util.LinkedHashMap;
import java.util.Map;

public enum YesOrNo {
	  YES(1, "是", "tech.enum.yesorno.yes"), NO(0, "否", "tech.enum.yesorno.no");

    private int id;

    private String name;

    private String i18n;

    private YesOrNo(int id, String name, String i18n) {
        this.id = id;
        this.name = name;
        this.i18n = i18n;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getI18nName() {
        return MessageSourceContext.getMessage(i18n);
    }

    public String getI18n() {
        return i18n;
    }

    public static Map<String, String> getMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(YesOrNo.values().length);
        for (YesOrNo c : YesOrNo.values()) {
            map.put(String.valueOf(c.getId()), MessageSourceContext.getMessage(c.getI18n()));
        }
        return map;
    }

    public static Map<String, String> getZhMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(YesOrNo.values().length);
        for (YesOrNo c : YesOrNo.values()) {
            map.put(String.valueOf(c.getId()), c.getName());
        }
        return map;
    }

    public static YesOrNo fromId(int id) {
        for (YesOrNo c : YesOrNo.values()) {
            if (c.getId() == id) {
                return c;
            }
        }
        return null;
    }

    public static YesOrNo fromName(String name) {
        if (StringUtil.isBlank(name)) {
            return NO;
        }
        for (YesOrNo c : YesOrNo.values()) {
            if (name.equals(c.getName())) {
                return c;
            }
        }
        return NO;
    }
}
