package com.huigou.topsun.base.dictionary.controller;

import com.huigou.topsun.base.dictionary.GlobalCode;
import com.huigou.topsun.base.dictionary.application.DictionaryImportApplication;
import com.huigou.topsun.technology.domain.query.ProcessQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.easysearch.EasySearch;
import com.huigou.uasp.bmp.common.easysearch.domain.model.EasySearchParse;
import com.huigou.uasp.bmp.common.easysearch.domain.model.QuerySchemeField;
import com.huigou.uasp.bmp.opm.application.MemEasySearcher;
import com.huigou.uasp.bmp.opm.application.impl.MemEasySearcherImpl;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Controller
@ControllerMapping("/globalCode")
public class GlobalCodeController extends CommonController {


    protected String getPagePath() {
        return "/excelImport/";
    }
    @Autowired
    DictionaryImportApplication dictionaryImportApplication;

    public String revampGlobalCode(){
        SDO sdo = this.getSDO();
        String code = sdo.getString("dictionaryCode");
        GlobalCode.set(code);
        return success();
    }

    public String forwardGlobalCode(){
        return forward("inputDictionariesCode");
    }

    @EasySearch(queryName = "dictionaryCodes")
    public Map<String, Object> queryDictionaryCodes(SDO sdo){
        Integer intPage = sdo.getInteger("intPage", 1);
        Integer pageSize = sdo.getInteger("pageSize",10);
        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
        List<QuerySchemeField> fields =
                Arrays.asList(new QuerySchemeField("id", "id", "string", 200L),
                        new QuerySchemeField("工序名称", "processName", "string", 200L),
                        new QuerySchemeField("工序类型", "processType", "hidden", 100L),
                        new QuerySchemeField("工序类型", "processTypeTextView", "string", 100L),
                        new QuerySchemeField("工时", "workHours", "string", 100L),
                        new QuerySchemeField("工序内容", "processContent", "hidden", 100L),
                        new QuerySchemeField("工序说明", "processRemark", "hidden", 100L)
                );
        EasySearchParse easySearchParse = new EasySearchParse();
        easySearchParse.setFields(fields);
        easySearchParse.setWidth(450L);
//        String processName = sdo.getString("paramValue");
//        ProcessQueryRequest queryRequest = sdo.toQueryRequest(ProcessQueryRequest.class);
//        queryRequest.setProcessName(processName);
//        Map<String, Object> map = processApplication.slicedProcessList(queryRequest);
        String code = sdo.getString("code");
        Map<String, Object> map = dictionaryImportApplication.querySaDictionary(code);
        List<Map<String, Object>> mapList =  (List<Map<String, Object>>)map.get("Rows");
        MemEasySearcher<Map<String, Object>> memEasySearcher = new MemEasySearcherImpl<>();
        Map<String, Object> model = memEasySearcher.search(mapList, easySearchParse, pageRequest, null);
        return model;
    }
}
